import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const InformationIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`${className}`}
        viewBox="0 0 14 14"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M5.70282 0.115169C4.3966 0.35415 3.08241 1.03923 2.09478 2.01905C-0.684932 4.75937 -0.700862 9.18051 2.06292 11.9368C4.81873 14.701 9.23918 14.685 11.9791 11.9049C14.265 9.58678 14.6552 6.04986 12.9269 3.27768C11.4215 0.856009 8.54625 -0.402623 5.70282 0.115169ZM7.67012 3.80344C7.8772 4.01852 7.91703 4.11412 7.91703 4.44869C7.91703 4.79123 7.8772 4.87886 7.65419 5.1019C7.43118 5.32495 7.34356 5.36478 7.00108 5.36478C6.65859 5.36478 6.57098 5.32495 6.34797 5.1019C6.12495 4.87886 6.08513 4.79123 6.08513 4.45666C6.08513 4.04242 6.28425 3.72378 6.64266 3.56446C6.93736 3.437 7.40728 3.54056 7.67012 3.80344ZM7.43914 6.55969L7.63826 6.75087V8.59103V10.4312L7.43914 10.6224C7.18427 10.8852 6.81789 10.8852 6.56302 10.6224L6.3639 10.4312V8.59103V6.75087L6.56302 6.55969C6.68249 6.43223 6.84975 6.36054 7.00108 6.36054C7.15241 6.36054 7.31967 6.43223 7.43914 6.55969Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default InformationIcon;
