import { IconProps } from "@/interfaces/IconProps";

const FooterIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={` ${className}`}
        viewBox="0 0 65 65"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M6.23488 1.09777C3.73488 1.97277 1.93488 3.82277 1.13488 6.32277C0.759881 7.42277 0.734881 10.1978 0.784881 33.1728L0.859881 58.7978L1.48488 60.0478C2.25988 61.6478 3.75988 63.1478 5.35988 63.9228L6.60988 64.5478H58.8599L60.1099 63.9228C61.7099 63.1478 63.2099 61.6478 63.9849 60.0478L64.6099 58.7978V6.54777L63.9849 5.29777C63.2099 3.69777 61.7099 2.19777 60.1099 1.42277L58.8599 0.797772L33.1099 0.747772C10.1849 0.697772 7.23488 0.722772 6.23488 1.09777ZM57.8599 6.32277C59.5599 7.12277 59.4849 5.72277 59.4849 32.6728C59.4849 59.6228 59.5599 58.2228 57.8599 59.0228C57.1349 59.3728 54.3349 59.4228 32.7349 59.4228C11.1349 59.4228 8.33488 59.3728 7.60988 59.0228C5.90988 58.2228 5.98488 59.6228 5.98488 32.6728C5.98488 11.0978 6.03488 8.27277 6.38488 7.54777C7.18488 5.84777 5.75988 5.92277 32.6849 5.92277C54.3599 5.92277 57.1349 5.97277 57.8599 6.32277Z"
          className="fill-current"
        />
        <path
          d="M14.1103 35.7724C13.1853 36.1974 12.1103 37.3224 11.7603 38.2474C11.3353 39.3474 11.4103 50.2474 11.8353 51.2474C12.2353 52.2224 13.3603 53.2974 14.3103 53.6474C15.2853 54.0224 50.1853 54.0224 51.1603 53.6474C52.1103 53.2974 53.2353 52.2224 53.6353 51.2474C54.1353 50.0974 54.1353 39.2474 53.6353 38.0974C53.2353 37.1224 52.1103 36.0474 51.1603 35.6974C50.0103 35.2474 15.0853 35.3474 14.1103 35.7724Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default FooterIcon;
