import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const FaltasIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 23 23"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M5.36571 0.961558C4.7294 1.12755 4.05159 1.74312 3.85102 2.33101C3.60894 3.03649 3.78185 3.91488 4.25908 4.48202C4.39741 4.63419 4.69482 4.85551 4.92998 4.97309C5.28963 5.15983 5.42796 5.1875 5.88445 5.1875C6.34093 5.1875 6.47926 5.15983 6.83891 4.97309C7.07407 4.85551 7.37148 4.63419 7.50981 4.48202C7.98704 3.91488 8.15995 3.03649 7.91788 2.33101C7.77263 1.90911 7.26773 1.3558 6.83891 1.13447C6.46543 0.947726 5.7392 0.857812 5.36571 0.961558Z"
          className="fill-current"
        />
        <path
          d="M15.7407 0.961558C15.1044 1.12755 14.4266 1.74312 14.226 2.33101C13.9839 3.03649 14.1569 3.91488 14.6341 4.48202C14.7724 4.63419 15.0698 4.85551 15.305 4.97309C15.6646 5.15983 15.803 5.1875 16.2594 5.1875C16.7159 5.1875 16.8543 5.15983 17.2139 4.97309C17.4491 4.85551 17.7465 4.63419 17.8848 4.48202C18.362 3.91488 18.535 3.03649 18.2929 2.33101C18.1476 1.90911 17.6427 1.3558 17.2139 1.13447C16.8404 0.947726 16.1142 0.857812 15.7407 0.961558Z"
          className="fill-current"
        />
        <path
          d="M3.07922 5.9979C2.66423 6.4198 2.187 7.29127 2.104 7.76159L2.0625 8.02441H5.88037H9.69824L9.65674 7.76159C9.54608 7.15294 8.93052 6.14314 8.4187 5.74199L8.23196 5.58983L8.01063 5.77657C6.87634 6.73104 4.98815 6.73796 3.79853 5.80424C3.6602 5.69358 3.52878 5.60366 3.50112 5.60366C3.48037 5.60366 3.29363 5.78349 3.07922 5.9979Z"
          className="fill-current"
        />
        <path
          d="M13.4464 5.9979C13.0314 6.4198 12.5542 7.29127 12.4712 7.76159L12.4297 8.02441H16.2476H20.0654L20.0239 7.76159C19.9133 7.15294 19.2977 6.14314 18.7859 5.74199L18.5991 5.58983L18.3778 5.77657C17.2435 6.73104 15.3553 6.73796 14.1657 5.80424C14.0274 5.69358 13.896 5.60366 13.8683 5.60366C13.8476 5.60366 13.6608 5.78349 13.4464 5.9979Z"
          className="fill-current"
        />
        <path
          d="M0.200577 9.53625L0 9.73683V10.7881C0 12.3512 0.0276657 12.3789 1.61845 12.3789H2.59366L2.82191 11.9293C3.42364 10.7674 4.5441 10.0965 5.87897 10.0965C7.21384 10.0965 8.3343 10.7674 8.93603 11.9293L9.16428 12.3789H15.3268C19.6565 12.3789 21.5516 12.3582 21.7107 12.3028C22.0773 12.1783 22.1326 11.9639 22.1326 10.7881V9.73683L21.932 9.53625L21.7314 9.33568H11.0663H0.401153L0.200577 9.53625Z"
          className="fill-current"
        />
        <path
          d="M5.36983 11.4125C4.06262 11.7445 3.35714 13.2108 3.92429 14.4211C4.3047 15.2165 4.99634 15.6592 5.87473 15.6592C6.71853 15.6592 7.40326 15.2442 7.79749 14.4972C7.95657 14.1929 7.98424 14.0615 7.98424 13.522C7.98424 12.9825 7.95657 12.8511 7.79749 12.5468C7.58309 12.1318 7.14735 11.7237 6.73928 11.5439C6.37963 11.3848 5.72948 11.3226 5.36983 11.4125Z"
          className="fill-current"
        />
        <path
          d="M15.8577 14.4835L15.6641 14.6495V15.5971V16.5446L15.8577 16.7106C16.1344 16.9458 16.4802 16.9319 16.743 16.676C16.9436 16.4755 16.9436 16.4755 16.9436 15.5971C16.9436 14.7187 16.9436 14.7187 16.743 14.5181C16.4802 14.2622 16.1344 14.2484 15.8577 14.4835Z"
          className="fill-current"
        />
        <path
          d="M12.7563 15.0081C12.535 15.098 12.3828 15.3539 12.3828 15.6236C12.3828 15.8311 12.4589 15.9418 12.9915 16.4744C13.5586 17.0415 13.6209 17.083 13.8837 17.083C14.1188 17.083 14.2018 17.0415 14.3471 16.8686C14.6722 16.4813 14.6099 16.3084 13.8837 15.5821C13.2266 14.9251 13.109 14.8628 12.7563 15.0081Z"
          className="fill-current"
        />
        <path
          d="M18.6343 15.5752C17.9011 16.3084 17.8389 16.4813 18.164 16.8686C18.3092 17.0415 18.3922 17.083 18.6274 17.083C18.8902 17.083 18.9524 17.0415 19.5196 16.4744C20.0591 15.928 20.1282 15.838 20.1282 15.6098C20.1282 15.2778 19.9 15.015 19.5542 14.9597C19.2983 14.9182 19.2775 14.932 18.6343 15.5752Z"
          className="fill-current"
        />
        <path
          d="M3.05326 16.4963C2.79044 16.773 2.54144 17.1326 2.3962 17.4439C2.14029 17.9833 1.9743 18.5712 2.03654 18.6819C2.09188 18.7649 9.65845 18.7649 9.71379 18.6819C9.77603 18.5712 9.61004 17.9833 9.35413 17.4439C9.20197 17.1119 8.96681 16.7799 8.69015 16.4894L8.26134 16.0398L7.89476 16.3165C7.34145 16.7384 6.86422 16.8905 6.03424 16.932C5.04519 16.9735 4.51263 16.8006 3.62041 16.1505C3.48208 16.0467 3.45441 16.0606 3.05326 16.4963Z"
          className="fill-current"
        />
        <path
          d="M0.339597 20.0922C0.0352736 20.2582 -0.0131414 20.4933 0.0145243 21.6414C0.0352736 22.6167 0.04219 22.6927 0.194352 22.838L0.35343 22.9971H11.067H21.7805L21.9396 22.838C22.0918 22.6927 22.0987 22.6167 22.1194 21.6414C22.1471 20.4795 22.0987 20.2512 21.7805 20.0922C21.4901 19.94 0.616254 19.94 0.339597 20.0922Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default FaltasIcon;
