import { IconProps } from "@/interfaces/IconProps";

const EventosIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 21 22"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M3.95759 0.854414C3.57678 1.08825 3.47656 1.41562 3.47656 2.49126C3.47656 3.27293 3.50329 3.47336 3.61018 3.7072C3.77721 4.08801 4.07117 4.26172 4.54552 4.26172C5.01987 4.26172 5.31383 4.08801 5.48086 3.7072C5.58775 3.47336 5.61448 3.27293 5.61448 2.49126C5.61448 1.70958 5.58775 1.50915 5.48086 1.27532C5.31383 0.8945 5.01987 0.720794 4.54552 0.720794C4.29164 0.720794 4.11126 0.76088 3.95759 0.854414Z"
          className="fill-current"
        />
        <path
          d="M9.69978 0.854414C9.31896 1.08825 9.21875 1.41562 9.21875 2.49126C9.21875 3.27293 9.24547 3.47336 9.35237 3.7072C9.51939 4.08801 9.81336 4.26172 10.2877 4.26172C10.7687 4.26172 11.056 4.08801 11.2364 3.68715C11.3567 3.41323 11.3633 3.26625 11.3433 2.371C11.3233 1.43566 11.3099 1.33545 11.1696 1.13502C11.0827 1.01476 10.9291 0.874457 10.8222 0.821009C10.5416 0.674028 9.96702 0.694071 9.69978 0.854414Z"
          className="fill-current"
        />
        <path
          d="M15.4844 0.873941C15.0836 1.14118 15.0234 1.35497 15.0234 2.49074C15.0234 3.62651 15.0836 3.8403 15.4844 4.10754C15.7784 4.30797 16.373 4.32133 16.6536 4.13426C17.0611 3.86702 17.0945 3.74009 17.0945 2.49074C17.0945 1.24139 17.0611 1.11446 16.6536 0.847217C16.373 0.660149 15.7784 0.673511 15.4844 0.873941Z"
          className="fill-current"
        />
        <path
          d="M0.982105 2.72161C0.654737 2.82183 0.327368 3.12915 0.160344 3.48325C0.00668099 3.8173 0 3.8507 0 5.94185V8.06641H10.0215H20.043V5.94185V3.8173L19.8626 3.44984C19.7356 3.21601 19.5753 3.02226 19.3882 2.88864C19.1076 2.69489 19.0542 2.68821 18.3059 2.66149L17.5176 2.64144L17.4908 3.16256C17.4641 3.77053 17.3038 4.07786 16.8561 4.3785C16.502 4.6257 15.8406 4.66578 15.4531 4.46535C14.9186 4.19811 14.6314 3.677 14.6314 2.99553V2.6548H13.195H11.7585V3.01558C11.7585 3.95092 11.1773 4.59229 10.3221 4.59229C9.47364 4.59229 8.88572 3.96428 8.88572 3.05566V2.6548H7.45598H6.03293L5.98617 3.13584C5.93272 3.72376 5.74565 4.07786 5.35815 4.35846C5.09091 4.53884 5.01742 4.55889 4.54307 4.55889C4.06872 4.55889 3.99523 4.53884 3.73467 4.35846C3.36054 4.09122 3.13338 3.65695 3.0933 3.08907L3.05321 2.6548L2.11119 2.66149C1.59676 2.66149 1.08232 2.69489 0.982105 2.72161Z"
          className="fill-current"
        />
        <path
          d="M0.013362 14.6309C0.0334049 20.3832 0.0334049 20.3966 0.180387 20.7106C0.380816 21.1515 0.821762 21.5991 1.26271 21.8129L1.63684 22H10.0215H18.4061L18.7803 21.8129C19.2212 21.5991 19.6622 21.1515 19.8626 20.7106C20.0096 20.3966 20.0096 20.3832 20.0296 14.6309L20.043 8.87186H10.0215H0L0.013362 14.6309ZM15.0656 11.3371C15.3195 11.4841 15.5533 11.8249 15.6068 12.1255C15.7137 12.6934 15.7204 12.68 12.3732 16.0472C9.32666 19.1005 8.96589 19.4211 8.58507 19.4278C8.10404 19.4278 7.95038 19.3142 6.29349 17.6707C5.27798 16.6552 4.62324 15.9537 4.54307 15.7867C4.3226 15.3324 4.39609 14.8513 4.73682 14.4572C5.05751 14.0964 5.6922 14.0296 6.15987 14.3035C6.32022 14.397 6.72108 14.7511 7.06181 15.0985C7.39585 15.4393 7.87021 15.9136 8.11072 16.1541L8.55167 16.5884L11.1773 13.9628C13.1816 11.9652 13.8697 11.3171 14.0702 11.2369C14.3775 11.13 14.7717 11.1634 15.0656 11.3371Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default EventosIcon;
