import { IconProps } from "@/interfaces/IconProps";

const EstudianteIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={` ${className}`}
        viewBox="0 0 19 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M8.31646 0.053256C7.99032 0.107613 5.97915 0.553331 3.85927 1.04253C0.380492 1.85787 0 1.96659 0 2.16227C0 2.35795 0.391363 2.46666 4.0767 3.33636C9.22964 4.54306 8.9796 4.54306 12.7193 3.65162C14.2195 3.30374 15.4697 3.03196 15.5241 3.0537C15.5675 3.07545 15.6002 3.71685 15.6002 4.46696V5.82586L15.0892 6.78252C14.6435 7.59786 14.6 7.76093 14.7196 7.91313C14.8827 8.10881 15.2305 8.14142 15.3284 7.97835C15.4262 7.81528 15.6002 7.8479 15.6002 8.03271C15.6002 8.11968 15.698 8.23926 15.8176 8.30449C16.0024 8.40233 16.0785 8.36972 16.285 8.16316C16.4807 7.94574 16.5568 7.924 16.709 8.02184C16.9373 8.16316 17.2634 8.01097 17.3178 7.73919C17.3395 7.65222 17.1547 7.23911 16.9047 6.81514L16.4698 6.05415V4.42347V2.78192L17.3178 2.57537C18.0027 2.40143 18.1549 2.33621 18.1549 2.16227C18.1549 1.96659 17.7309 1.847 14.1108 1.00992C9.76233 -0.00109959 9.22964 -0.088069 8.31646 0.053256Z"
          className="fill-current"
        />
        <path
          d="M5.05469 4.81539V5.46766L5.5765 5.55463C5.85916 5.59812 7.43548 5.6416 9.07703 5.6416C10.7186 5.6416 12.2949 5.59812 12.5884 5.55463L13.0994 5.46766V4.81539C13.0994 4.46751 13.0885 4.17399 13.0668 4.17399C13.045 4.17399 12.2732 4.34793 11.3491 4.55448C10.4251 4.76104 9.40316 4.93497 9.07703 4.93497C8.75089 4.93497 7.729 4.76104 6.80495 4.55448C5.8809 4.34793 5.10904 4.17399 5.0873 4.17399C5.06556 4.17399 5.05469 4.46751 5.05469 4.81539Z"
          className="fill-current"
        />
        <path
          d="M4.62861 6.78087C3.161 9.05295 3.36755 11.6403 5.1613 13.5645C7.29205 15.8366 10.8578 15.8366 12.9886 13.5645C14.5757 11.8577 14.9345 9.53128 13.9235 7.50924C13.7169 7.0744 13.4234 6.59606 13.2929 6.44387C13.0429 6.15034 13.032 6.15034 12.1732 6.25906C11.2165 6.36777 5.54179 6.31341 5.24827 6.18296C5.09607 6.1286 4.96561 6.25906 4.62861 6.78087Z"
          className="fill-current"
        />
        <path
          d="M5.65604 16.1853C2.32946 16.9137 0.590066 18.8923 0.318286 22.2732L0.242188 23.1973H9.08046H17.9187L17.8426 22.2732C17.56 18.8379 15.6901 16.7724 12.2875 16.1419L11.6569 16.0223L11.2764 16.4571C10.6785 17.1638 10.1676 17.3812 9.08046 17.3812C7.99335 17.3812 7.4824 17.1638 6.88448 16.4571C6.67793 16.218 6.46051 16.0223 6.40615 16.0332C6.3518 16.0332 6.01479 16.1093 5.65604 16.1853Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default EstudianteIcon;
