import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const EscanerQRIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-auto ${className}`}
        width="60"
        height="60"
        viewBox="0 0 60 60"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M0.308281 0.308281C-0.10276 0.719323 -0.10276 14.7915 0.308281 15.2025C0.501713 15.3959 1.49305 15.4926 3.20975 15.4926H5.82108V10.947C5.82108 7.73121 5.91779 6.30465 6.11122 6.11122C6.30465 5.91779 7.73121 5.82108 10.947 5.82108H15.4926V3.20975C15.4926 1.49305 15.3959 0.501713 15.2025 0.308281C14.7915 -0.10276 0.719323 -0.10276 0.308281 0.308281Z"
          className="fill-current"
        />
        <path
          d="M44.7975 0.308281C44.6041 0.501713 44.5074 1.49305 44.5074 3.20975V5.82108H49.053C52.2688 5.82108 53.6953 5.91779 53.8888 6.11122C54.0822 6.30465 54.1789 7.73121 54.1789 10.947V15.4926H56.7903C58.507 15.4926 59.4983 15.3959 59.6917 15.2025C60.1028 14.7915 60.1028 0.719323 59.6917 0.308281C59.2807 -0.10276 45.2085 -0.10276 44.7975 0.308281Z"
          className="fill-current"
        />
        <path
          d="M14.9607 13.9452C13.655 14.6464 13.5583 15.1783 13.5583 21.4165V27.0985H15.4926V21.5857C15.4926 17.6204 15.5652 16.0004 15.7828 15.7828C16.1938 15.3718 43.8062 15.3718 44.2172 15.7828C44.4348 16.0004 44.5074 17.6204 44.5074 21.5857V27.0985H46.4417V21.4165C46.4417 15.13 46.345 14.6222 44.9909 13.921C43.9512 13.3891 15.952 13.3891 14.9607 13.9452Z"
          className="fill-current"
        />
        <path
          d="M0.308281 29.323C-0.0785814 29.7099 -0.0544024 30.3627 0.356639 30.7012C0.598429 30.8946 8.55329 30.943 30.1209 30.9188C57.8541 30.8463 59.5708 30.8221 59.8368 30.411C60.0302 30.1209 60.0302 29.8791 59.8368 29.5648C59.5708 29.1779 57.8541 29.1537 30.0725 29.0812C7.34435 29.057 0.525892 29.1054 0.308281 29.323Z"
          className="fill-current"
        />
        <path
          d="M13.5583 38.5835C13.5583 44.87 13.655 45.3778 15.0091 46.079C16.0729 46.6351 43.9271 46.6351 44.9909 46.079C46.345 45.3778 46.4417 44.87 46.4417 38.5835V32.9015H44.5074V38.4143C44.5074 42.3796 44.4348 43.9996 44.2172 44.2172C43.8062 44.6283 16.1938 44.6283 15.7828 44.2172C15.5652 43.9996 15.4926 42.3796 15.4926 38.4143V32.9015H13.5583V38.5835Z"
          className="fill-current"
        />
        <path
          d="M0.308281 44.7975C-0.10276 45.2085 -0.10276 59.2807 0.308281 59.6917C0.719323 60.1028 14.7915 60.1028 15.2025 59.6917C15.3959 59.4983 15.4926 58.507 15.4926 56.7903V54.1789H10.947C7.73121 54.1789 6.30465 54.0822 6.11122 53.8888C5.91779 53.6953 5.82108 52.2688 5.82108 49.053V44.5074H3.20975C1.49305 44.5074 0.501713 44.6041 0.308281 44.7975Z"
          className="fill-current"
        />
        <path
          d="M54.1789 49.053C54.1789 52.2688 54.0822 53.6953 53.8888 53.8888C53.6953 54.0822 52.2688 54.1789 49.053 54.1789H44.5074V56.7903C44.5074 58.507 44.6041 59.4983 44.7975 59.6917C45.2085 60.1028 59.2807 60.1028 59.6917 59.6917C60.1028 59.2807 60.1028 45.2085 59.6917 44.7975C59.4983 44.6041 58.507 44.5074 56.7903 44.5074H54.1789V49.053Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default EscanerQRIcon;
