import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const EquisIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`*:fill-current ${className}`}
        viewBox="0 0 16 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M0.45551 0.600118C0.100282 0.760116 -0.0798342 1.17011 0.0402431 1.5651C0.0902753 1.7451 0.565582 2.24509 3.45744 5.14005L6.81961 8.5L3.48246 11.84C1.15596 14.1599 0.120295 15.2299 0.0652592 15.3599C-0.199912 16.0049 0.385465 16.6499 1.0559 16.4499C1.23601 16.3999 1.73133 15.9299 4.6282 13.0349L7.99537 9.67498L11.3575 13.0299C14.9749 16.6349 14.8748 16.5499 15.3151 16.4799C15.8254 16.3949 16.1306 15.8549 15.9455 15.3649C15.9205 15.2899 14.3995 13.7299 12.5333 11.8649L9.17112 8.5L12.5333 5.13505C14.3995 3.27008 15.9205 1.7101 15.9455 1.6351C16.1306 1.14511 15.8254 0.605118 15.3151 0.520119C14.8748 0.450119 14.9749 0.365122 11.3575 3.97007L7.99537 7.32502L4.65321 3.99007C2.32171 1.6601 1.26103 0.630117 1.13095 0.575118C0.885788 0.475119 0.710675 0.48012 0.45551 0.600118Z"
        />
      </svg>
    </div>
  );
};

export default EquisIcon;
