import { IconProps } from "@/interfaces/IconProps";

const DirectivoIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`text-inherit ${className}`}
        viewBox="0 0 44 41"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M12.2891 0.108718C10.3469 0.538137 9.09225 2.39603 9.37584 4.43797C9.54772 5.7087 10.3297 6.78663 11.4727 7.35627C12.0571 7.64547 12.1087 7.65424 13.1055 7.65424C14.111 7.65424 14.154 7.64547 14.7383 7.35627C15.8813 6.77787 16.6462 5.72623 16.8352 4.4555C17.1532 2.39603 15.804 0.459264 13.8016 0.0824266C13.1743 -0.0315011 12.8993 -0.0315011 12.2891 0.108718Z"
          className="fill-current"
        />
        <path
          d="M7.5625 8.81104C7.14141 8.87239 6.30781 9.21417 5.88672 9.49461C5.01875 10.0555 4.24531 11.186 4.03906 12.1938C3.97891 12.5005 3.95313 14.0342 3.97031 16.7334L3.99609 20.8085L4.23672 21.1853C4.36563 21.3869 4.59766 21.6323 4.75234 21.7199L5.02734 21.8952H2.76719H0.498438L0.249219 22.1493C0.00859375 22.3947 0 22.4385 0 23.2536C0 23.718 0.0429688 24.1738 0.0859375 24.2702C0.266406 24.6032 0.61875 24.6996 1.71875 24.6996H2.75V32.8498V41H22H41.25V32.8498V24.6996H42.2813C43.3813 24.6996 43.7336 24.6032 43.9141 24.2702C43.957 24.1738 44 23.718 44 23.2536C44 22.4385 43.9914 22.3947 43.7508 22.1493L43.5016 21.8952H38.2508H33V20.8436V19.7919H35.2773C37.8211 19.7919 38.0789 19.7481 38.3797 19.2398C38.5344 18.9681 38.543 18.7666 38.543 14.3146C38.543 9.18788 38.5688 9.40697 38.0102 9.0389C37.7953 8.88991 37.3141 8.88115 31.1523 8.85486C27.5172 8.83733 24.3633 8.85486 24.157 8.88115C23.882 8.92497 23.693 9.02137 23.4867 9.2317L23.2031 9.5209V14.2971C23.2031 19.0558 23.2031 19.0645 23.3922 19.3099C23.7359 19.7569 23.9422 19.7919 26.4258 19.7919H28.7031V20.8436V21.8952H25.5664H22.4297V17.3556C22.4297 13.7625 22.4039 12.7021 22.3008 12.2289C21.9656 10.5988 20.668 9.26675 19.0438 8.88115C18.6227 8.78475 18.107 8.74969 17.0844 8.76722L15.7008 8.79351L15.5375 9.49461C15.2195 10.9056 14.6781 12.2376 14.2055 12.816L13.9992 13.0702L14.0594 12.6145C14.1195 12.1588 13.9734 11.1685 13.8102 10.9581C13.7586 10.8968 13.518 10.853 13.1914 10.853C12.8648 10.853 12.6156 10.8968 12.5641 10.9581C12.4094 11.1597 12.2719 12.1062 12.3234 12.6057L12.375 13.0877L12.1688 12.8248C11.6961 12.2376 11.1375 10.8004 10.7422 9.11777L10.6477 8.74969L9.2125 8.75846C8.42188 8.76722 7.68281 8.79351 7.5625 8.81104ZM8.33594 15.0157V17.5134H10.957C13.9391 17.5134 14.1711 17.5572 14.85 18.2145C15.7695 19.1171 15.9672 20.5105 15.3141 21.5359L15.0906 21.8952H14.4805H13.8789L14.2141 21.6673C14.618 21.3869 14.9531 20.7033 14.9531 20.1337C14.9531 19.5816 14.6094 18.9156 14.1625 18.6001L13.8102 18.3459L10.725 18.3196L7.64844 18.2933V15.6642C7.64844 13.9728 7.68281 12.9738 7.74297 12.8599C7.82031 12.7021 8.07813 12.5356 8.27578 12.5268C8.31016 12.5181 8.33594 13.6398 8.33594 15.0157ZM18.4852 12.7722L18.7344 13.0264V17.4608V21.8952H18.3906H18.0469V17.2066C18.0469 13.9203 18.0727 12.5181 18.1414 12.5181C18.193 12.5181 18.3477 12.632 18.4852 12.7722ZM31.5391 13.1491C32.0117 13.4821 32.1836 13.7888 32.1836 14.3146C32.1836 14.6564 32.132 14.8492 32.0031 15.0332C31.2297 16.1024 29.7516 15.7694 29.5109 14.4724C29.4422 14.0868 29.7688 13.412 30.1555 13.1578C30.5508 12.8861 31.1523 12.8861 31.5391 13.1491Z"
          className="fill-current"
        />
        <path
          d="M12.2672 8.81104C12.1297 8.9425 12.3102 10.3272 12.4907 10.5638C12.5422 10.6339 12.8 10.6777 13.1954 10.6777C13.5907 10.6777 13.8485 10.6339 13.9086 10.5638C14.029 10.4236 14.2266 9.07395 14.1579 8.88991C14.1149 8.77599 13.9516 8.74969 13.2125 8.74969C12.7227 8.74969 12.293 8.77599 12.2672 8.81104Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default DirectivoIcon;
