import { IconProps } from "@/interfaces/IconProps";

const DespliegueIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 44 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M2.05018 0.0850716C1.12213 0.379175 0.408896 1.10969 0.11673 2.0679C-0.0809126 2.72251 -0.0207606 3.83252 0.245627 4.42072C0.494827 4.97098 14.9227 20.9569 15.9281 21.7918C17.0796 22.7595 18.6178 23.5184 20.0786 23.841C21.0754 24.0592 23.0604 24.0497 23.9799 23.8315C25.4579 23.4805 26.9703 22.75 28.053 21.8582C28.3881 21.5925 32.0059 17.6743 36.1048 13.1584C44.5261 3.87046 43.9933 4.56303 43.9933 3.04508C43.9933 2.34303 43.9589 2.10584 43.787 1.71687C43.5207 1.1002 43.0308 0.56892 42.4465 0.255842C42.0512 0.047123 41.8622 0.00917435 41.2435 0.00917435C40.6162 0.0186615 40.4443 0.0566101 40.0404 0.284304C39.6537 0.502508 38.1757 2.07738 32.0918 8.78483C24.8048 16.8015 24.5986 17.0292 23.9713 17.3518C22.5276 18.1013 20.9637 18.0159 19.6317 17.1146C19.3739 16.9343 16.2203 13.5284 11.769 8.63304C5.76242 2.02046 4.25862 0.407637 3.93208 0.246355C3.41649 -0.000312805 2.56577 -0.07621 2.05018 0.0850716Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default DespliegueIcon;
