import { IconProps } from "@/interfaces/IconProps";

const DescargarIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-auto ${className}`}
        width="20"
        height="19"
        viewBox="0 0 20 19"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M8.64238 0.0639228C8.32182 0.179474 8.06381 0.490573 7.96999 0.855003C7.92308 1.03277 7.89181 2.37494 7.89181 3.90377V6.64144H6.64084C5.41334 6.64144 5.38206 6.65033 5.19442 6.86365C5.06932 6.99698 4.99895 7.18364 4.99895 7.35252C4.99895 7.59251 5.19442 7.86806 6.35156 9.24578C9.0724 12.5079 9.79171 13.3078 10.0028 13.3078C10.2061 13.3078 11.0661 12.3568 13.7401 9.1569C14.819 7.85917 15.0067 7.59251 15.0067 7.35252C15.0067 7.18364 14.9363 6.99698 14.8112 6.86365C14.6235 6.65033 14.5923 6.64144 13.3726 6.64144H12.1216L12.0982 3.726C12.0747 1.12166 12.0591 0.783894 11.934 0.570569C11.6447 0.0728113 11.4883 0.0194801 10.1201 0.00170306C9.43205 -0.00718548 8.76748 0.0194801 8.64238 0.0639228Z"
          className="fill-current"
        />
        <path
          d="M0.894379 15.299C0.581638 15.4501 0.229805 15.859 0.104709 16.2145C-0.0516614 16.6323 -0.0282059 17.5478 0.143802 17.9745C0.315809 18.4189 0.683279 18.7833 1.07421 18.9078C1.48077 19.0322 18.533 19.0322 18.9395 18.8989C19.651 18.6767 20.0497 17.9211 19.995 16.8812C19.9637 16.179 19.7839 15.7879 19.3226 15.4323L19.0412 15.219L10.089 15.2012C2.77864 15.1835 1.08202 15.2012 0.894379 15.299Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default DescargarIcon;
