import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const ComunicadosIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 26 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M19.4484 0.0906913C19.2753 0.173109 18.0473 2.15937 17.8577 2.66212C17.6929 3.09893 18.0967 3.61816 18.5995 3.61816C18.6984 3.61816 18.8797 3.51926 19.0033 3.38739C19.3248 3.05772 20.4951 0.956076 20.4951 0.69234C20.4951 0.41212 20.083 -0.00820971 19.8193 3.19481e-05C19.7121 3.19481e-05 19.5473 0.0412407 19.4484 0.0906913Z"
          className="fill-current"
        />
        <path
          d="M12.3364 0.915084C12.1386 1.02223 11.8583 1.24475 11.7265 1.41783C11.4792 1.72278 11.471 1.77223 11.4627 2.53047C11.4545 3.32168 11.4545 3.33816 11.0342 4.17058C10.5644 5.09365 9.77318 6.30519 9.04791 7.20354C8.41329 8.003 6.98747 9.46179 6.22098 10.1129C5.86659 10.4096 5.57812 10.6733 5.57812 10.7063C5.57812 10.764 8.76769 16.3107 8.84186 16.3849C8.86659 16.4096 9.35285 16.2695 9.92977 16.0799C12.6413 15.1816 15.3776 14.7777 17.471 14.9673C18.3611 15.0497 18.46 15.0744 18.7155 15.3052C19.0864 15.6266 19.5149 15.7585 20.0094 15.7173C20.9902 15.6184 21.699 14.5387 21.3858 13.6321C21.3199 13.4508 20.7182 12.3629 20.0507 11.209C19.0122 9.42058 18.8556 9.09915 18.971 9.03322C19.2924 8.86014 19.7127 8.41508 19.8446 8.11014C20.0424 7.67333 20.0424 6.8986 19.8446 6.45355C19.6633 6.0497 19.0864 5.53871 18.6908 5.43157C18.2292 5.30794 17.6853 5.34091 17.2897 5.52223C16.993 5.65409 16.9023 5.66234 16.8281 5.57992C16.7704 5.52223 16.2018 4.56618 15.5589 3.4453C14.9243 2.33267 14.3144 1.34366 14.2237 1.23651C13.9682 0.964535 13.4243 0.733766 13.0369 0.733766C12.8474 0.733766 12.5424 0.816183 12.3364 0.915084Z"
          className="fill-current"
        />
        <path
          d="M23.3799 3.39605C22.7041 3.75045 21.336 4.57463 21.1794 4.71474C20.9074 4.96199 20.9239 5.45649 21.2041 5.73671C21.3772 5.90979 21.4678 5.93452 21.7151 5.90155C22.0695 5.8521 23.9898 4.77243 24.27 4.46748C24.5255 4.18726 24.509 3.82463 24.2123 3.52792C23.9486 3.27243 23.7014 3.23122 23.3799 3.39605Z"
          className="fill-current"
        />
        <path
          d="M21.6076 8.60475C21.3274 8.87673 21.3274 9.29706 21.6158 9.58552L21.8384 9.7998H23.3548H24.8796L25.1186 9.56079C25.4153 9.26409 25.4235 8.98387 25.1433 8.6542L24.929 8.39871H23.3713C21.8219 8.39871 21.8054 8.39871 21.6076 8.60475Z"
          className="fill-current"
        />
        <path
          d="M3.68301 11.506C3.25444 11.7615 2.54564 12.1736 2.11707 12.4208C1.6885 12.6763 1.18575 13.039 0.987952 13.2368C0.542897 13.7065 0.155534 14.4813 0.0401493 15.1736C-0.174136 16.484 0.485204 17.9346 1.63905 18.6681C2.4385 19.1791 3.76542 19.3439 4.63081 19.0472C4.93575 18.9401 7.82861 17.3494 8.0429 17.1681C8.08411 17.1351 4.56488 11.0362 4.50718 11.0445C4.48246 11.0445 4.11158 11.2505 3.68301 11.506Z"
          className="fill-current"
        />
        <path
          d="M7.53932 18.6429C6.9624 18.9643 6.48438 19.2528 6.48438 19.2775C6.48438 19.4011 9.27833 22.8792 9.45965 22.9781C9.78108 23.1594 10.0531 23.0357 10.6877 22.4259C11.4377 21.7088 11.4459 21.5852 10.7948 20.7363C10.5311 20.3901 9.9624 19.6484 9.53383 19.0797C9.10525 18.511 8.71789 18.0495 8.66844 18.0495C8.62723 18.0412 8.11624 18.3132 7.53932 18.6429Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default ComunicadosIcon;
