import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const CompartirIcon = ({className,title}:IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-auto ${className}`}
        viewBox="0 0 15 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M11.5351 16.4198C11.0157 16.2946 10.6215 16.0694 10.2148 15.6689C9.45146 14.8993 9.21368 13.9107 9.5328 12.7844C9.55783 12.6781 9.25123 12.4716 7.23642 11.2702L4.90875 9.88119L4.63343 10.1315C4.48326 10.2754 4.17666 10.4756 3.94515 10.582C3.58849 10.7509 3.43831 10.7822 2.93148 10.801C2.03045 10.8385 1.36719 10.582 0.779018 9.96253C-0.259673 8.88007 -0.259673 7.17816 0.779018 6.0957C1.36719 5.47626 2.03045 5.21972 2.93148 5.25726C3.43831 5.27603 3.58849 5.30732 3.9514 5.47626C4.20169 5.59514 4.52706 5.82039 4.74606 6.02687L5.11524 6.38352L7.3115 5.26352C9.41391 4.19983 9.50151 4.14351 9.47023 3.99335C9.24497 2.95468 9.50151 2.04742 10.2148 1.32786C10.8718 0.670873 11.7478 0.389307 12.6364 0.539476C13.2621 0.645845 13.7251 0.883611 14.1694 1.32786C15.2769 2.44161 15.2769 4.16854 14.1694 5.28229C13.0681 6.37727 11.3536 6.38352 10.2336 5.30106L9.90823 4.98195L8.65679 5.62643C5.70967 7.12811 5.48441 7.25325 5.52821 7.36587C5.63458 7.6099 5.63458 8.29191 5.53447 8.6861C5.45312 9.00521 5.44687 9.09281 5.50944 9.13035C5.55324 9.15538 6.59193 9.78108 7.81208 10.5194L10.0334 11.8647L10.3149 11.6144C11.1784 10.851 12.3923 10.6758 13.431 11.1701C13.894 11.3891 14.4947 11.9898 14.7137 12.4528C15.2331 13.5603 15.0203 14.8117 14.1694 15.6689C13.456 16.376 12.4924 16.6513 11.5351 16.4198Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default CompartirIcon;
