import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const CamaraIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`${className}`}
        viewBox="0 0 25 21"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M15.3157 0.0558914C16.0154 0.290509 16.3225 0.60634 17.2696 2.1133C17.6536 2.72692 18.0631 3.28639 18.1826 3.37663C18.302 3.45784 18.6092 3.54808 18.8652 3.56613L19.3259 3.60222V3.20518C19.3259 2.98861 19.3857 2.7179 19.4625 2.60961C19.5819 2.42011 19.6502 2.41109 20.7253 2.41109C22.0478 2.41109 22.1416 2.46523 22.1416 3.15104V3.5571L22.756 3.60222C23.7287 3.67441 24.4283 4.15267 24.8208 5.02797C25 5.43404 25 5.48819 25 12.3372L25 19.2404L24.8123 19.6103C24.5137 20.1969 24.2235 20.5127 23.7457 20.7654L23.302 21L1.69795 21L1.25426 20.7654C0.776449 20.5127 0.486347 20.1969 0.187714 19.6103L0 19.2404L0 12.3372C0 5.48819 0 5.43404 0.17918 5.02797C0.401024 4.54069 0.810579 4.0895 1.27133 3.82782C1.6041 3.63832 1.76621 3.62929 4.09556 3.58418C6.27986 3.54808 6.6041 3.52101 6.80887 3.37663C6.93686 3.29542 7.34642 2.72692 7.73038 2.1133C8.53242 0.840957 8.83106 0.489031 9.30034 0.218319C9.62457 0.0288202 9.75256 0.0197964 12.372 0.00174893C13.8737 -0.00727481 15.1962 0.0197964 15.3157 0.0558914ZM10.7594 5.04602C8.55802 5.68671 6.76621 7.60876 6.17747 9.96396C5.93003 10.9295 5.93003 12.4726 6.16894 13.4291C6.77474 15.8294 8.59215 17.7605 10.8532 18.3921C11.7747 18.6538 13.2253 18.6538 14.1468 18.3921C16.4079 17.7605 18.1826 15.8835 18.8225 13.4562C19.087 12.4635 19.087 10.9566 18.8225 9.95494C18.1058 7.22074 15.9727 5.23552 13.3362 4.8475C12.6109 4.74824 11.5017 4.82945 10.7594 5.04602Z"
          className="fill-current"
        />
        <path
          d="M13.1952 7.12497C14.74 7.51686 16.0459 8.9241 16.3702 10.5451C16.669 12.0236 16.2422 13.4843 15.1924 14.5798C13.4939 16.3522 10.8992 16.3522 9.2007 14.5798C7.5022 12.8074 7.5022 10.0998 9.2007 8.32736C10.2761 7.20513 11.7527 6.7598 13.1952 7.12497ZM13.8865 11.0082C13.7414 11.124 13.6475 11.3111 13.6134 11.5694C13.5024 12.3264 13.1183 12.7361 12.3416 12.9232C11.7698 13.0568 11.5223 13.3596 11.693 13.7337C11.8637 14.0899 12.1709 14.179 12.7428 14.0454C13.6987 13.8227 14.4669 13.0211 14.6803 12.0236C14.8083 11.4447 14.723 11.1062 14.4157 10.9459C14.1426 10.8034 14.134 10.8034 13.8865 11.0082Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default CamaraIcon;
