import { IconProps } from "@/interfaces/IconProps";

const CalendarioIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={className}
        viewBox="0 0 19 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M18.9062 10.3437V17.6354C18.9062 18.188 18.6868 18.7179 18.2961 19.1086C17.9054 19.4993 17.3755 19.7187 16.8229 19.7187H2.23958C1.68705 19.7187 1.15714 19.4993 0.766444 19.1086C0.375743 18.7179 0.15625 18.188 0.15625 17.6354V10.3437H18.9062ZM13.6979 0.96875C13.9742 0.96875 14.2391 1.0785 14.4345 1.27385C14.6298 1.4692 14.7396 1.73415 14.7396 2.01042V3.05208H16.8229C17.3755 3.05208 17.9054 3.27158 18.2961 3.66228C18.6868 4.05298 18.9062 4.58288 18.9062 5.13542V8.26042H0.15625V5.13542C0.15625 4.58288 0.375743 4.05298 0.766444 3.66228C1.15714 3.27158 1.68705 3.05208 2.23958 3.05208H4.32292V2.01042C4.32292 1.73415 4.43266 1.4692 4.62801 1.27385C4.82336 1.0785 5.08832 0.96875 5.36458 0.96875C5.64085 0.96875 5.9058 1.0785 6.10115 1.27385C6.2965 1.4692 6.40625 1.73415 6.40625 2.01042V3.05208H12.6562V2.01042C12.6562 1.73415 12.766 1.4692 12.9613 1.27385C13.1567 1.0785 13.4216 0.96875 13.6979 0.96875Z" className="fill-current"/>
      </svg>
    </div>
  );
};

export default CalendarioIcon;