import { ModoRegistro } from "@/interfaces/shared/ModoRegistro";
import { PersonalDelColegio } from "@/interfaces/shared/PersonalDelColegio";
import { RolesSistema } from "@/interfaces/shared/RolesSistema";

export enum SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935 {
  //Salas de toma de asistencia de Directivo
  SALA_TOMA_ASISTENCIA_DIRECTIVO_ENTRADA = "SALA_TOMA_ASISTENCIA_DIRECTIVO_ENTRADA",
  SALA_TOMA_ASISTENCIA_DIRECTIVO_SALIDA = "SALA_TOMA_ASISTENCIA_DIRECTIVO_SALIDA",

  //Salas de toma de asistencia de Auxiliares
  SALA_TOMA_ASISTENCIA_AUXILIARES_ENTRADA = "SALA_TOMA_ASISTENCIA_AUXILIARES_ENTRADA",
  SALA_TOMA_ASISTENCIA_AUXILIARES_SALIDA = "SALA_TOMA_ASISTENCIA_AUXILIARES_SALIDA",

  //Salas de toma de asistencia de profesores de primaria
  SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_ENTRADA = "SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_ENTRADA",
  SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_SALIDA = "SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_SALIDA",

  //Salas de toma de asistencia de profesores o tutores de secundaria
  SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_ENTRADA = "SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_ENTRADA",
  SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_SALIDA = "SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_SALIDA",

  //Salas de toma de asistencia de Personal Administrativo
  SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_ENTRADA = "SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_ENTRADA",
  SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_SALIDA = "SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_SALIDA",
}

export const SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935_MAPPER: Record<
  PersonalDelColegio,
  Record<ModoRegistro, SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935>
> = {
  [RolesSistema.Directivo]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_DIRECTIVO_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_DIRECTIVO_SALIDA,
  },
  [RolesSistema.Auxiliar]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_AUXILIARES_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_AUXILIARES_SALIDA,
  },
  [RolesSistema.ProfesorPrimaria]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA_SALIDA,
  },
  [RolesSistema.ProfesorSecundaria]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_SALIDA,
  },
  [RolesSistema.Tutor]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PROFESORES_TUTORES_SECUNDARIA_SALIDA,
  },

  [RolesSistema.PersonalAdministrativo]: {
    [ModoRegistro.Entrada]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_ENTRADA,
    [ModoRegistro.Salida]:
      SALAS_TOMA_ASISTENCIA_PERSONAL_IE20935.SALA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO_SALIDA,
  },
};
