# Sistema de Asistencia Escolar - Colegio Asunción 8 (N° 20935)

Este proyecto es un sistema de asistencia escolar diseñado para el Colegio Asunción 8 (N° 20935). Su objetivo principal es optimizar el registro, seguimiento y control de la asistencia de los estudiantes, mejorando la eficiencia administrativa y fortaleciendo la comunicación con los responsables.

---

## Características Principales

- **Control de Tardanzas y Faltas Recurrentes:** Notificaciones automáticas a responsables tras detectar patrones.
- **Optimización de Procesos:** Generación de reportes en Excel directamente en Google Drive.
- **Alertas y Notificaciones:** Sistema de alertas para mantener informados a los directivos sobre situaciones críticas.
- **Módulos Específicos:** Administración de estudiantes, profesores, eventos, responsables, entre otros.
- **Accesibilidad:** Compatibilidad con comandos de voz y teclas rápidas para personas ciegas.
- **Carga Masiva de Datos:** Integración con archivos CSV para agilizar registros masivos.

---

## Tecnologías Utilizadas

- **Frontend:** Next.js 14 con TypeScript.
- **Backend:** APIs desplegadas en Vercel con Node.js.
- **Base de Datos:** PostgreSQL alojada en Neon.
- **Notificaciones por Correo:** Resend para envío de alertas.
- **Almacenamiento en la Nube:** Google Drive para guardar reportes y archivos.
- **Diseño:** Figma para prototipos e interfaces.
- **Control de Versiones:** Git y GitHub.

---

## Metodología

Se sigue la metodología **Scrum**, con iteraciones de desarrollo y entregas continuas. Se está considerando la adopción de **Scrumban** para optimizar los flujos de trabajo.

---

## Instalación

1. Clona el repositorio:
   ```bash
   git clone <URL-del-repositorio>
   ```
2. Instala las dependencias:
   ```bash
   npm install
   ```
3. Configura las variables de entorno en un archivo `.env`.
4. Ejecuta el proyecto en desarrollo:
   ```bash
   npm run dev
   ```

---

## Funcionalidades

- **Administración de Estudiantes:** Registro, búsqueda y gestión de datos.
- **Reportes:** Generación automática de reportes de asistencia.
- **Notificaciones Automáticas:** Avisos por correo electrónico en situaciones críticas.
- **Control de Eventos:** Programación y monitoreo de actividades escolares.
- **Historial de Asistencia:** Seguimiento detallado de la asistencia por estudiante.
- **Acceso Rápido:** Soporte para teclas rápidas y comandos de voz.

---

## Contribuciones

Se aceptan contribuciones para mejorar el sistema. Para colaborar:
1. Haz un fork del repositorio.
2. Crea una nueva rama:
   ```bash
   git checkout -b feature/nueva-funcionalidad
   ```
3. Realiza tus cambios y haz un commit:
   ```bash
   git commit -m "Descripción de los cambios"
   ```
4. Sube tus cambios:
   ```bash
   git push origin feature/nueva-funcionalidad
   ```
5. Abre un pull request.

---

## Licencia

Este proyecto está bajo la licencia **MIT**.

---

## Contacto

- **Desarrollador Principal:** Juan Chávez
- **Correo Electrónico:** juanchavez@colegio20935.edu
- **Colegio:** Asunción 8 (N° 20935)

