module ScatteringGraphs

using Combinatorics
using Oscar
using LinearAlgebra
using HomotopyContinuation
using RowEchelon
using Random


export oscar_to_HC_Q,
HC_to_oscar,
create_point_of_M0m,
get_coeffs_kernel,
get_coeffs_kernel_Oscar,
get_all_tuples,
get_prod_minors,
get_complete_graph,
is_union_of_completegraphs,
ML_deg_formula,
get_dim_fiber,
momentum_conservation,
solve_momentum_cons,
get_pluecker,
get_scattering_eqns,
get_nonedges_bipyramid,
find_start_solution,
solve_monodromy,
ML_deg_monodromy,
get_data,
likelihoodIdeal_complete,
get_compatible_graphs,
get_edges,
bigraded_ring,
get_momentum_conservation,
get_coeffs_matrix,
get_cleared_scatt_eqs,
get_scattering_eqns_HC,
theta,
get_codimension_kinematic_space,
get_coeff_mat_HC,
get_start_sol_multideg,
get_system_HC,
get_numerical_multidegree,
read_m2_list_of_lists,
get_L_M0m,
get_Ramification,
get_deg_DeltaLog,
check_condition_18,
is_copious



include("Utils.jl")
include("ScatteringEquations.jl")
include("Graphs.jl")
include("Hypertrees.jl")
include("CommutativeAlgebra.jl")
include("Discriminants.jl")

end 