
### Julia script by Leonie Kayser, Andreas Kretschmer and Simon Telen, supplemented to Logarithmic discriminants of hyperplane arrangements


function get_L_M0m(m)
    inds = collect(Combinatorics.powerset(1:m-2, 2, 2))
    L = zeros(Int,m-2,m-3+length(inds))
    L[2:end,1:m-3] = diagm(ones(Int,m-3))
    for i = 1:length(inds)
        L[inds[i],m-3+i] = [-1;1]
    end
    return L
end

function get_Ramification(L)
    A = L[2:end,:]
    d, n = size(L).-(1,1)
    @var u[1:n+1] x[1:d] y[1:n+1] v[1:d]
    ℓ = [1 transpose(x)]*L
    LE = [[y[i]*ℓ[i]-1 for i =1:n+1];A*diagm(u)*y] # likelihood equations    
    Hess = A*diagm(-u.*(y.^2))*transpose(A) # Hessian matrix
    # The ramification locus is defined by LE and Hess*v = 0, where the latter encodes 
    # that the Hessian determinant has determinant zero. 
    return [LE;Hess*v; dot(randn(ComplexF64,d),v)-1], u, x, y, v
end

function get_deg_DeltaLog(L)
    d, n = size(L).-(1,1)
    Ram, u, x, y, v = get_Ramification(L)
    @var t
    myc = randn(ComplexF64,n+1)
    myd = randn(ComplexF64,n+1)
    param =  myc + t.*myd # a random parametric line
    R = HomotopyContinuation.solve(System(subs(Ram,u=>param), variables = [t;v;x;y]))
    uvals = [HomotopyContinuation.evaluate(System(param),[sol[1]]) for sol in solutions(R)]
    return length(unique_points(uvals)) 
end
