needsPackage("Graphs")

--gbTrace = 3

-- Create indices set of the s_ij, excluding the one in the NonEdge set
SIndx = (n, NE)-> ( 
    SIndices := flatten flatten for i from 1 to n list(
        for j from i+1 to n list(
        {{i,j}}
    )
    );
    SIndices - set(NE)
)

-- Create bigraded ring Q[a,b,c..., s12,..,], with s_ij iff ij \not\in NE
bigraded_ring = (n, NE) ->(
    S := apply(SIndx(n,NE), a-> s_a);
    deg := join( for i from 1 to n list( {0,1} ), for i from 1 to (length(S)) list({1,0})); --  deg(a)=(0,1), deg(s_ij)=(1,0)
    G := join((a..z)_(toList(0..n-1)), S);
    R := QQ[G, Degrees=> deg]
)

-- Create momentum conservation law 
MomentumConservation = (n, R, NE)->(
    Sind := SIndx(n,NE);
    for i from 1 to n list(
        sum apply(select(Sind, ind -> ind_0 == i or ind_1 == i ), a->s_a)
    )
)

-- Generators as in Eq (12) Arrangements and Likelihood
theta = (n,R,NE,h) ->(
    G := gens R;
    Sind := SIndx(n,NE);
    sum for ind in Sind list(
        s_ind * (sum flatten entries monomials (G_(ind_0-1) + G_(ind_1-1))^h)
    )
)

-- Compute multidegree, betti table, minimal generators and check primality of the saturated prelikelihood ideal assocaited to the set of non edges NE
-- does not use separator based derivations
getData = (n,NE) ->(
    R = bigraded_ring(n,NE);
    Gen = gens R;
    I = ideal( for h from 2 to n-2 list(theta(n,R,NE,h)) ) + ideal(MomentumConservation(n,R,NE));
    mnrs := flatten for i from 1 to n-1 list(
        for j from i+1 to n list(
        Gen_(i-1) - Gen_(j-1)
        )
    );
    -- saturating
    for m in mnrs do(
        I = I : m -- replace with linsat
    );
    --print ("Non Edges:", NE);
    --print("Betti table"); print betti mingens I;
    --print("I is prime:", isPrime I);
    --print("Multidegree:", multidegree I)
    return( multidegree I, betti mingens I, mingens I, isPrime I)
)



-------------------------------------------------------
-- Functions to compute separator based derivations----
-------------------------------------------------------


-- Check if a vertex subset S disconnects the graph G
isSeparator = (G, S) -> (
    V := vertices G;
    remaining := set V - set S;
    if #remaining == 0 then (
        true
    ) else (
        H := inducedSubgraph(G, toList remaining);
        #connectedComponents H > 1
    )
)

-- Get all separators of the graph G
Separators = (G) -> (
    V = vertices G;
    allSubsets = delete(vertices G, subsets(V));
    select(allSubsets, S -> (#S > 0 and isSeparator(G, S)))
)

-- Check if a separator S is minimal (no proper subset of S also disconnects G)
isMinimalSeparator = (G, S) -> (
    isSeparator(G, S) and all(subsets(S, #S - 1), T -> not isSeparator(G, T))
)



-- Get all minimal separators inclusion-wise
minimalSeparators = (G) -> (
    V = vertices G;
    allSubsets = delete(vertices G, subsets(V));
    select(allSubsets, S -> (#S > 0 and isMinimalSeparator(G, S)))
)


------------------- Input -----------------------
-- n        numbert of vertices of the graph
-- NE       set of non edges of the graph
-- R        bigraded ring of the ideal of the scattering correspondence associated to NE
-- T        separator of the graph G = NE^C 
------------------- Output -----------------------
-- list of separator based derivations (applied to logarithmic potential) for every connected component of G\T 
--(as before Thm. 5.8  Arrangements and Likelihood)
separatorBasedDerivation = (n,NE,R,T) ->(
    Gen := gens R;
    S := Gen - set(Gen_(toList(0..n-1))); -- s_ij
    Sind := SIndx(n, NE);
    hyperplanesNonzero := for I in Sind list( Gen_(I_1-1) - Gen_(I_0-1));

    G := graph(toList(1..n),NE);
    G = complementGraph G;
    V := vertices G;
    remaining := set V - set T;
    H := inducedSubgraph(G, toList remaining);
    ConnectedComp := connectedComponents H;
    for C in ConnectedComp list(
        sum for i in C list(
            product(for t in T list( Gen_(i-1) - Gen_(t-1) )) * sum( for s from 0 to length(S)-1 list( S_s * diff(Gen_(i-1), hyperplanesNonzero_s  )/ hyperplanesNonzero_s ))
        )
    )
)


-- Compute all separator based derivation for a graph with Nonedges NE
AllSeparatorBasedDerivation = (n,NE,R) ->(
    G := complementGraph graph(toList(1..n),NE);
    --separators = minimalSeparators(G);
    separators := Separators(G);

    SepBaseDer := flatten for T in separators list(
        separatorBasedDerivation(n,NE,R,T)
    );
    apply(SepBaseDer, numerator )
)


-- Compute dimension, multidegree, betti table, minimal generators and check primality of 
-- the saturated prelikelihood ideal associated to the set of non edges NE using separator based derivations
getDataSeparator = (n,NE) ->(
    R := bigraded_ring(n,NE);
    Gen := gens R;
    G := complementGraph graph(toList(1..n),NE);
    ConnG := vertexConnectivity G;

    Theta := flatten for h from 2 to ConnG list(theta(n,R,NE,h));
    I0 := ideal( join( Theta, AllSeparatorBasedDerivation(n,NE,R), MomentumConservation(n,R,NE) ));
    -- I = ideal( for h from 2 to n-2 list(theta(n,R,NE,h)) ) + ideal(MomentumConservation(n,R,NE));

    --Sind := SIndx(n, NE);
    --hyperplanesNonzero := for I in Sind list( Gen_(I_1-1) - Gen_(I_0-1)); --minors of M_0,n corresponding to nonzero s_ij

    -- saturating
    mnrs := flatten for i from 1 to n-1 list(
       for j from i+1 to n list( Gen_(i-1) - Gen_(j-1) )); -- all minors defining of M_0,n
    
    for m in mnrs do(
        I0 = I0 : m 
        --I0 = linSat(I0, m) -- Ben function
    );
    print("Saturation hyperplanes complete");

    Prime := isPrime(I0);
    SaturationSij := false;
    if (Prime == false ) then (
        SaturationSij = true;
        I0 = I0 : ideal(Gen_(toList(n..(numgens R -1)))); -- saturate w.r.t. nonzero s_ij
        print("Saturated w.r.t. s_ij");
    );

    return( I0, dim I0, multidegree I0, betti mingens I0, mingens I0, isPrime I0, SaturationSij)
)



-- if you use this method and the asumptions are not met then the output will probably be wrong or it will just error
linSat = (I, f) -> (
    -- assumptions for this case:
    --   (1) the ring is of the form k[x1..xn].  No quotients, k a field or ZZ, grevlex order
    --   (2) all variables have degree 1.
    --   (3) I is homogeneous
    --   (4) f = homog linear form
    
    R := ring I;
    S := newRing(R, Degrees => toList( numgens R:1));

    J := sub(I,S);
    
    --if not isFlatPolynomialRing R
    --or not isGRevLexRing R
    -- TODO: what does this do?
    res := newCoordinateSystem(S, matrix{{sub(f,S)}});
    fto := res#1;
    fback := res#0;
    v := S_(numgens S - 1);
    -- this degree limit can be changed, the lower it is the faster the computation will be
    -- but of course the more polynomials you might miss
    g := gens gb(fto J, DegreeLimit => 12);
    return sub(ideal fback first divideByVariable(g, v), R)
)

