load("Utils.m2")

n=6
-- Copious graphs for n=6
CopiousGraphs6 = {{}, 
{{1,2}},
{{1,2},{3,4}},
{{1,2},{2,3}},
{{1,2},{3,4},{4,5}},
{{1,2},{3,4},{5,6}},
{{1,2},{3,4},{4,5},{5,6}},
{{1,2},{2,3},{3,4}},
{{1,2},{2,3},{3,4},{4,5}},
{{1,2},{2,3},{3,4},{4,5},{5,6}},
{{1,2},{2,3},{1,5},{4,5},{3,4}},
{{1,2},{1,3},{2,3}},
{{1,2},{1,3},{2,3},{4,5}},
{{1,2},{1,3},{2,3},{4,5},{5,6},{4,6}}}


-- Get data for copious graphs for n=6 and print in.txt file
for  i in toList(0..14) do(
    print(i); NE = CopiousGraphs6_i;
    t = timing getDataSeparator(n,NE);
    CompTime = t#0;
    (I, Dimension, MultiDeg, BettiTable, MinGen, Prime, SaturationSij ) = t#1;
    f = openOutAppend "Multidegrees6.txt"; -- to not overwrite
    f << toString i << endl; f << "NonEdges:"  << endl;
    f << toString NE << endl; f << "Dimension of saturated ideal:"  << endl;
    f << toString Dimension << endl; f << "Multidegree:"  << endl;
    f << toString MultiDeg << endl; f << "Betti table:"  << endl;
    f << toString BettiTable << endl; f << "Degree of generators:"  << endl;
    f << toString tally apply(flatten entries MinGen, degree) << endl; f << "IsPrime:"  << endl;
    f << toString Prime << endl; f << "Computational time:"  << endl;
    f << toString CompTime << endl; 
    f << "Saturation s_ij:"  << endl;
    f << toString SaturationSij << endl;
    f << endl;
    close f
)
