# Phenotypic variation and genome-wide association studies of main culm panicle node number, maximum node production rate, and degree-days to heading in rice

This publication discusses: Grain yield is a complex trait that results from interaction between underlying phenotypic traits and climatic, edaphic, and biotic variables. In rice, main culm panicle node number (MCPNN; the node number on which the panicle is borne) and maximum node production rate (MNPR; the number of leaves that emerge per degree-day > 10°C) are primary phenotypic plant traits that have significant positive direct effects on yield-related traits. Degree-days to heading (DDTH), which has a significant positive effect on grain yield, is influenced by the interaction between MCPNN and MNPR. The objective of this research is to assess the phenotypic variation of MCPNN, MNPR, and DDTH in a panel of diverse rice accessions, determine regions in the rice genome associated with these traits using genome-wide association studies (GWAS), and identify putative candidate genes that control these traits.  Results Considerable variation was observed for the three traits in a 220-genotype diverse rice population. MCPNN ranged from 8.1 to 20.9 nodes in 2018 and from 9.9 to 21.0 nodes in 2019. MNPR ranged from 0.0097 to 0.0214 nodes/degree day > 10°C in 2018 and from 0.0108 to 0.0193 nodes/degree-day > 10°C in 2019. DDTH ranged from 713 to 2,345 degree-days > 10°C in 2018 and from 778 to 2,404 degree-days > 10°C in 2019.  Thirteen significant (P < 2.91 x 10-7) trait-single nucleotide polymorphism (SNP) associations were identified using the multilocus mixed linear model for GWAS. Significant associations between MCPNN and three SNPs in chromosome 2 (S02_12032235, S02_11971745, and S02_12030176) were detected with both the 2018 and best linear unbiased prediction (BLUP) datasets. Nine SNPs in chromosome 6 (S06_1970442, S06_2310856, S06_2550351, S06_1968653, S06_2296852, S06_1968680, S06_1968681, S06_1970597, and S06_1970602) were significantly associated with MNPR in the 2019 dataset. One SNP in chromosome 11 (S11_29358169) was significantly associated with the DDTH in the BLUP dataset.  Conclusions This study identifies SNP markers that are putatively associated with MCPNN, MNPR, and DDTH. Some of these SNPs were located within or near gene models, which identify possible candidate genes involved in these traits. Validation of the putative candidate genes through expression and gene editing analyses are necessary to confirm their roles in regulating MCPNN, MNPR, and DDTH. Identifying the underlying genetic basis for primary phenotypic traits MCPNN and MNPR could lead to the development of fast and efficient approaches for their estimation, such as marker-assisted selection and gene editing, which is essential in increasing breeding efficiency and enhancing grain yield in rice. On the other hand, DDTH is a resultant variable that is highly affected by nitrogen and water management, plant density, and several other factors.

It contains 220 genotypes and 854832 markers.

Title: Phenotypic variation and genome-wide association studies of main culm panicle node number, maximum node production rate, and degree-days to heading in rice

Scientific name: Oryza sativa

Common name: Rice

DOI: https://doi.org/10.5061/dryad.4qrfj6qbs


