# Identification and marker development of a moderate-effect fire blight resistance QTL in M. sieversii, the primary progenitor of domesticated apples

This publication discusses: Fire blight, a bacterial disease caused by Erwinia amylovora, is the most devastating disease of apples and a major threat to apple production. Most commercial apple cultivars are susceptible to fire blight, driving the need to develop fire-blight-resistant cultivars. Although several major fire blight resistance QTLs have been identified from wild species of Malus, the challenges of breeding apples due to long juvenile phase and heterozygosity greatly limit their use. M. sieversii, the primary progenitor of domesticated apples, is one of the wild Malus species that is sexually compatible with M. domestica and has some favorable fruit quality traits. In this study, we performed QTL analysis on two F1 apple populations of M. domestica cv. “Royal Gala” × M. sieversii (GMAL4591 and GMAL4592) to identify fire blight resistance QTL. Parental linkage maps were constructed for each family using marker sets of approximately 20K GBS-SNPs. Phenotype data was collected from parents and progeny through controlled fire blight inoculations in the greenhouse for two subsequent years. A significant (P < 0.0001) moderate-effect fire blight resistance QTL on linkage group 7 of GMAL4591 was identified from the paternal parent M. sieversii “KAZ 95 17-14” (Msv_FB7). Msv_FB7 explains about 48–53% of the phenotyping variance across multiple years and time points. Additionally, a significant (P < 0.001) minor effect QTL explaining 18% of the phenotypic variance was identified in population GMAL4592 on LG10 from “Royal Gala.” We developed diagnostic SSR markers flanking the Msv_FB7 QTL to use in apple breeding. These findings have the potential to accelerate the development of fire-blight-resistant cultivars.

It contains 165 genotypes and 26199 markers.

Title: Identification and marker development of a moderate-effect fire blight resistance QTL in M. sieversii, the primary progenitor of domesticated apples

Scientific name: Domesticated Apple

Common name: Malus domestica

DOI: https://doi.org/10.5061/dryad.15dv41p3c


