# An SNP-based second-generation genetic map of Daphnia magna and its application to QTL analysis of phenotypic traits

This publication discusses: Background
Although Daphnia is increasingly recognized as a model for ecological genomics and biomedical research, there is, as of yet, no high-resolution genetic map for the genus. Such a map would provide an important tool for mapping phenotypes and assembling the genome. Here we estimate the genome size of Daphnia magna and describe the construction of an SNP array based linkage map. We then test the suitability of the map for life history and behavioural trait mapping. The two parent genotypes used to produce the map derived from D. magna populations with and without fish predation, respectively and are therefore expected to show divergent behaviour and life-histories.

Results
Using flow cytometry we estimated the genome size of D. magna to be about 238 mb. We developed an SNP array tailored to type SNPs in a D. magna F2 panel and used it to construct a D. magna linkage map, which included 1,324 informative markers. The map produced ten linkage groups ranging from 108.9 to 203.6 cM, with an average distance between markers of 1.13 cM and a total map length of 1,483.6 cM (Kosambi corrected). The physical length per cM is estimated to be 160 kb. Mapping infertility genes, life history traits and behavioural traits on this map revealed several significant QTL peaks and showed a complex pattern of underlying genetics, with different traits showing strongly different genetic architectures.

Conclusions
The new linkage map of D. magna constructed here allowed us to characterize genetic differences among parent genotypes from populations with ecological differences. The QTL effect plots are partially consistent with our expectation of local adaptation under contrasting predation regimes. Furthermore, the new genetic map will be an important tool for the Daphnia research community and will contribute to the physical map of the D. magna genome project and the further mapping of phenotypic traits. The clones used to produce the linkage map are maintained in a stock collection and can be used for mapping QTLs of traits that show variance among the F2 clones.

It contains 353 genotypes and 1324 markers.

Title: An SNP-based second-generation genetic map of Daphnia magna and its application to QTL analysis of phenotypic traits

Scientific name: Daphnia magna

Common name: Water flea

DOI: https://doi.org/10.5061/dryad.qk8fj


