# Genetic loci associated with winter survivorship in diverse lowland switchgrass populations

This publication discusses: High winter mortality limits biomass yield of lowland switchgrass (Panicum virgatum L.) planted in the northern latitudes of North America. Breeding of cold tolerant switchgrass cultivars requires many years due to its perennial growth habit and the unpredictable winter selection pressure that is required to identify winter-hardy individuals. Identification of causal genetic variants for winter survivorship would accelerate the improvement of switchgrass biomass production. The objective of this study was to identify allelic variation associated with winter survivorship in lowland switchgrass populations using bulk segregant analysis (BSA). Twenty-nine lowland switchgrass populations were evaluated for winter survival at two locations in southern Wisconsin and 21 populations with differential winter survivorship were used for BSA. A maximum of 10% of the individuals (8–20) were bulked to create survivor and nonsurvivor DNA pools from each population and location. The DNA pools were evaluated using exome capture sequencing, and allele frequencies were used to conduct statistical tests. The BSA tests revealed nine quatitative trait loci (QTL) from tetraploid populations and seven QTL from octoploid populations. Many QTL were population-specific, but some were identified in multiple populations that originated across a broad geographic landscape. Four QTL (at positions 88 Mb on chromosome 2N, 115 Mb on chromosome 5K, and 1 and 100 Mb on chromosome 9N) were potentially the most useful QTL. Markers associated with winter survivorship in this study can be used to accelerate breeding cycles of lowland switchgrass populations and should lead to improvements in adaptation within USDA hardiness zones 4 and 5.

It contains 80 genotypes and 5596351 markers.

Title: Genetic loci associated with winter survivorship in diverse lowland switchgrass populations

Scientific name: Panicum virgatum

Common name: Switchgrass

DOI: https://doi.org/10.5061/dryad.9cnp5hqhv


