# Strong genetic structure in a widespread estuarine crab: A test of potential versus realized dispersal

This publication discusses: Aim: Genetic structure has proven difficult to predict for marine and estuarine species with multi-day pelagic larval durations, since many disperse far less than expected based on passive transport models. In such cases, the gap between potential and realized dispersal may result from larval behaviors that evolved to facilitate retention and settlement in favorable environments. Behavior is predicted to play a particularly key role in structuring truly estuarine species, which often moderate their behavior to remain within their natal estuaries. In such systems, this restricted dispersal may lead to high divergence, local adaptation, and eventual speciation across their range. Here, we test whether a geographically widespread estuarine crab, known to have behavior promoting larval retention, exhibits high population structure despite a 2-4 week larval duration.

Location: Atlantic and Gulf Coasts of North America Taxon: White-fingered mud crab, Rhithropanopeus harrisii

Methods: Population genomic analyses across nine estuaries from New Hampshire to Louisiana using 12,638 transcriptome-derived SNPs.

Results: We found highly differentiated genetic signatures among all nine estuaries, separated by 200-5,000 km of coastline. Estimates of gene flow suggest that migration is low and largely symmetrical between sites. We also observed deep phylogenetic divides corresponding to major biogeographic breaks.

Main conclusions: These results indicate substantial and longstanding constraints to dispersal in the species’ native range, likely arising from the emergence of geological and oceanographic barriers and sustained by behavior that promotes estuarine retention during larval development. This work supports the idea that larval behavior promoting estuarine retention can be reflected in substantial genetic structure even in species with multi-week pelagic larval durations. Such behavior-restricted dispersal has implications for predicting adaptation and spread in estuarine species, many of which have been introduced outside their native ranges.

It contains 78 genotypes and 12638 markers.

Title: Strong genetic structure in a widespread estuarine crab: A test of potential versus realized dispersal

Scientific name: Rhithropanopeus harrisii

Common name: White-fingered mud crab

DOI: https://doi.org/10.5061/dryad.qnk98sfd1


