# Genomic signals of local adaptation across climatically heterogenous habitats in an invasive tropical fruit fly (Bactrocera tryoni)

This publication discusses: Local adaptation plays a key role in the successful establishment of pest populations in new environments by enabling them to tolerate novel biotic and abiotic conditions experienced outside their native range. However, the genomic underpinnings of such adaptive responses remain unclear, especially for agriculturally important pests. We investigated population genomic signatures in the tropical/subtropical Queensland fruit fly, Bactrocera tryoni, which has an expanded range encompassing temperate and arid zones in Australia, and tropical zones in the Pacific Islands. Using reduced representation sequencing data from 28 populations, we detected allele frequency shifts associated with the native/invasive status of populations and identified environmental factors that have likely driven population differentiation. We also determined that precipitation, temperature, and geographic variables explain allelic shifts across the distribution range of B. tryoni. We found spatial heterogeneity in signatures of local adaptation across various climatic conditions in invaded areas. Specifically, disjunct invasive populations in the tropical Pacific Islands and arid zones of Australia were characterised by multiple significantly differentiated single nucleotide polymorphisms (SNPs), some of which were associated with genes with well-understood function in environmental stress (e.g., heat and desiccation) response. However, invasive populations in southeast Australian temperate zones showed higher gene flow with the native range and lacked a strong local adaptive signal. These results suggest that population connectivity with the native range has differentially affected local adaptive patterns in different invasive populations. Overall, our findings provide insights into the evolutionary underpinnings of invasion success of an important horticultural pest in climatically distinct environments.

It contains 301 genotypes and 6707 markers.

Title: Genomic signals of local adaptation across climatically heterogenous habitats in an invasive tropical fruit fly (Bactrocera tryoni)

Scientific name: Bactrocera tryoni

Common name: Queensland fruit fly

DOI: https://doi.org/10.5061/dryad.kkwh70s9q


