# Population genomic insights into invasion success in a polyphagous agricultural pest, Halyomorpha halys

This publication discusses: Invasive species are increasingly threatening ecosystems and agriculture by rapidly expanding their range and adapting to environmental and human-imposed selective pressures. The genomic mechanisms that underlie such rapid changes remain unclear, especially for agriculturally important pests. Here, we used genome-wide polymorphisms derived from native, invasive, and intercepted samples and populations of the brown marmorated stink bug (BMSB), Halyomorpha halys, to gain insights into population genomics processes that have promoted the successful global invasion of this polyphagous pest. Our analysis demonstrated that BMSB exhibits spatial structure but admixture rates are high among introduced populations, resulting in similar levels of genomic diversity across native and introduced populations. These spatial genomic patterns suggest a complex invasion scenario, potentially with multiple bridgehead events, posing a challenge for accurately assigning BMSB incursions to their source using reduced-representation genomic data. By associating allele frequencies with the invasion status of BMSB populations, we found significantly differentiated single nucleotide polymorphisms (SNPs) located in close proximity to genes for insecticide resistance and olfaction. Comparing variations in allele frequencies among populations for outlier SNPs suggests that BMSB invasion success has probably evolved from standing genetic variation. In addition to being a major nuisance of households, BMSB has caused significant economic losses to agriculture in recent years and continues to expand its range. Despite no record of BMSB insecticide resistance to date, our results show high capacity for potential evolution of such traits, highlighting the need for future sustainable and targeted management strategies.

It contains 404 genotypes and 14235 markers.

Title: Population genomic insights into invasion success in a polyphagous agricultural pest, Halyomorpha halys

Scientific name: Halyomorpha halys

Common name: Brown marmorated stink bug

DOI: https://doi.org/10.5061/dryad.w9ghx3fsk


