# GWAS, MWAS and mGWAS provide insights into precision agriculture based on genotype-dependent microbial effects in foxtail millet

This publication discusses: Genetic and environmental factors collectively determine plant growth and yield. In the past 20 years, genome-wide association studies (GWAS) have been conducted on crops to decipher genetic loci that contribute to growth and yield, however, plant genotype appears to be insufficient to explain the trait variations. Here, we unravel the associations between genotypic, phenotypic, and rhizoplane microbiota variables of 827 foxtail millet cultivars by an integrated GWAS, microbiome-wide association studies (MWAS) and microbiome genome-wide association studies (mGWAS) method. We identify 257 rhizoplane microbial biomarkers associated with six key agronomic traits and validated the microbial-mediated growth effects on foxtail millet using marker strains isolated from the field. The rhizoplane microbiota composition is mainly driven by variations in plant genes related to immunity, metabolites, hormone signaling and nutrient uptake. Among these, the host immune gene FLS2 and transcription factor bHLH35 are widely associated with the microbial taxa of the rhizoplane. We further uncover a plant genotype-microbiota interaction network that contributes to phenotype plasticity. The microbial-mediated growth effects on foxtail millet are dependent on the host genotype, suggesting that precision microbiome management could be used to engineer high-yielding cultivars in agriculture systems.

It contains 827 genotypes and 161562 markers.

Title: GWAS, MWAS and mGWAS provide insights into precision agriculture based on genotype-dependent microbial effects in foxtail millet

Scientific name: Setaria italica

Common name: Foxtail millet

DOI: https://doi.org/10.5281/zenodo.7018178


