# Design and characterization of an 87k SNP genotyping array for Arctic charr (Salvelinus alpinus)

This publication discusses: We have generated a high-density, high-throughput genotyping array for characterizing genome-wide variation in Arctic charr (Salvelinus alpinus). Novel single nucleotide polymorphisms (SNPs) were identified in charr from the Fraser, Nauyuk and Tree River aquaculture strains, which originated from northern Canada and fish from Iceland using high coverage sequencing, reduced representation sequencing and RNA-seq datasets. The array was designed to capture genome-wide variation from a diverse suite of Arctic charr populations. Cross validation of SNPs from various sources and comparison with previously published Arctic charr SNP data provided a set of candidate SNPs that generalize across populations. Further candidate SNPs were identified based on minor allele frequency, association with RNA transcripts, even spacing across intergenic regions and association with the sex determining (sdY) gene. The performance of the 86,503 SNP array was assessed by genotyping Fraser, Nauyuk and Tree River strain individuals, as well as wild Icelandic Arctic charr. Overall, 63,060 of the SNPs were polymorphic within at least one group and 36.8% were unique to one of the four groups, suggesting that the array design allows for characterization of both within and across population genetic diversity. The concordance between sdY markers and known phenotypic sex indicated that the array can accurately determine the sex of individuals based on genotype alone. The Salp87k genotyping array provides researchers and breeders the opportunity to analyze genetic variation in Arctic charr at a more detailed level than previously possible

It contains 951 genotypes and 86504 markers.

Title: Design and characterization of an 87k SNP genotyping array for Arctic charr (Salvelinus alpinus)

Scientific name: Salvelinus alpinus

Common name: Arctic char

DOI: https://doi.org/10.1371/journal.pone.0215008


