# A comparison of genomic selection models across time in interior spruce (Picea engelmannii ‚óä glauca) using unordered SNP imputation methods

This publication discusses: Genomic selection (GS) potentially offers an unparalleled advantage over traditional pedigree-based selection (TS) methods by reducing the time commitment required to carry out a single cycle of tree improvement. This quality is particularly appealing to tree breeders, where lengthy improvement cycles are the norm. We explored the prospect of implementing GS for interior spruce (Picea engelmannii √ó glauca) utilizing a genotyped population of 769 trees belonging to 25 open-pollinated families. A series of repeated tree height measurements through ages 3‚Äì40 years permitted the testing of GS methods temporally. The genotyping-by-sequencing (GBS) platform was used for single nucleotide polymorphism (SNP) discovery in conjunction with three unordered imputation methods applied to a data set with 60% missing information. Further, three diverse GS models were evaluated based on predictive accuracy (PA), and their marker effects. Moderate levels of PA (0.31‚Äì0.55) were observed and were of sufficient capacity to deliver improved selection response over TS. Additionally, PA varied substantially through time accordingly with spatial competition among trees. As expected, temporal PA was well correlated with age-age genetic correlation (r=0.99), and decreased substantially with increasing difference in age between the training and validation populations (0.04‚Äì0.47). Moreover, our imputation comparisons indicate that k-nearest neighbor and singular value decomposition yielded a greater number of SNPs and gave higher predictive accuracies than imputing with the mean. Furthermore, the ridge regression (rrBLUP) and BayesCœÄ (BCœÄ) models both yielded equal, and better PA than the generalized ridge regression heteroscedastic effect model for the traits evaluated.

It contains 769 genotypes and 55617 markers.

Title: A comparison of genomic selection models across time in interior spruce (Picea engelmannii ‚óä glauca) using unordered SNP imputation methods

Scientific name: Picea engelmannii ‚óä glauca

Common name: Interior Spruce

DOI: https://doi.org/10.5061/dryad.m4vh4


