# Genome-wide SNPs resolve spatiotemporal patterns of connectivity within striped marlin (Kajikia audax), a broadly distributed and highly migratory pelagic species

This publication discusses: Genomic methodologies offer unprecedented opportunities for statistically robust studies of species broadly distributed in environments conducive to high gene flow, providing valuable information for wildlife conservation and management. Here, we sequence restriction site-associated DNA to characterize genome-wide single nucleotide polymorphisms (SNPs) in a broadly distributed and highly migratory large pelagic fish, striped marlin (Kajikia audax). Assessment of over 4,000 SNPs resolved spatiotemporal patterns of genetic connectivity throughout the species range in the Pacific and, for the first time, Indian oceans. Individual-based cluster analyses identified six genetically distinct populations corresponding with the western Indian, eastern Indian, western South Pacific, and eastern central Pacific oceans, as well as two populations in the North Pacific Ocean (FST = 0.0137‚Äì0.0819). FST outlier analyses identified a subset of SNPs (n = 59) putatively under the influence of natural selection and capable of resolving populations separated by comparatively high degrees of genetic differentiation. Temporal collections available for some regions demonstrated the stability of allele frequencies over three to five generations of striped marlin. Relative migration rates reflected lower levels of genetic connectivity between Indian Ocean populations (mR ‚â§ 0.37) compared with most populations in the Pacific Ocean (mR ‚â• 0.57) and highlight the importance of the western South Pacific in facilitating gene flow between ocean basins. Collectively, our results provide novel insights into rangewide population structure for striped marlin and highlight substantial inconsistencies between genetically distinct populations and stocks currently recognized for fisheries management. More broadly, we demonstrate that species capable of long-distance dispersal in environments lacking obvious physical barriers to movement can display substantial population subdivision that persists over multiple generations and that may be facilitated by both neutral and adaptive processes. Importantly, surveys of genome-wide markers enable inference of population-level relationships using sample sizes practical for large pelagic fishes of conservation concern.

It contains 245 genotypes and 4206 markers.

Title: Genome-wide SNPs resolve spatiotemporal patterns of connectivity within striped marlin (Kajikia audax), a broadly distributed and highly migratory pelagic species

Scientific name: Kajikia audax

Common name: Striped marlin

DOI: https://doi.org/10.5061/dryad.3j9kd51cp


