# Genomic selection for recovery of original genetic background from hybrids of endangered and common breeds

This publication discusses: Critically endangered breeds and populations are often crossed with more common breeds or subspecies. This results in genetic admixture that can be undesirable when it challenges the genetic integrity of wild and domestic populations, causing a loss in special characteristics or unique genetic material and ultimately extinction. Here, we present two genomic selection strategies, using genome-wide DNA markers, to recover the genomic content of the original endangered population from admixtures. Each strategy relies on the estimation of the proportion of nonintrogressed genome in individuals based on a different method: either genomic prediction or identification of breed-specific haplotypes. Then, breeding programs that remove introgressed genomic information can be designed. To test these strategies, we used empirical 50K SNP array data from two pure sheep breeds, Merino (used as target breed), Poll Dorset and an existing admixed population of both breeds. Sheep populations with varying degrees of introgression and admixture were simulated starting from these real genotypes. Both strategies were capable of identifying segment origin, and both removed up to the 100% of the Poll Dorset segments. While the selection process led to substantial inbreeding, we controlled it by imposing a minimum number of individuals contributing to the next generation.

It contains 5963 genotypes and 54977 markers.

Title: Genomic selection for recovery of original genetic background from hybrids of endangered and common breeds

Scientific name: Ovis aries

Common name: Sheep

DOI: https://doi.org/10.5061/dryad.mn0d5


