# Population genetic inferences using immune gene SNPs mirror patterns inferred by microsatellites

This publication discusses: Single nucleotide polymorphisms (SNPs) are replacing microsatellites for population genetic analyses, but it is not apparent how many SNPs are needed or how well SNPs correlate with microsatellites. We used data from the gopher tortoise, Gopherus polyphemus‚Äîa species with small populations, to compare SNPs and microsatellites to estimate population genetic parameters. Specifically, we compared one SNP data set (16 tortoises from four populations sequenced at 17 901 SNPs) to two microsatellite data sets, a full data set of 101 tortoises and a partial data set of 16 tortoises previously genotyped at 10 microsatellites. For the full microsatellite data set, observed heterozygosity, expected heterozygosity and FST were correlated between SNPs and microsatellites; however, allelic richness was not. The same was true for the partial microsatellite data set, except that allelic richness, but not observed heterozygosity, was correlated. The number of clusters estimated by structure differed for each data set (SNPs = 2; partial microsatellite = 3; full microsatellite = 4). Principle component analyses (PCA) showed four clusters for all data sets. More than 800 SNPs were needed to correlate with allelic richness, observed heterozygosity and expected heterozygosity, but only 100 were needed for FST. The number of SNPs typically obtained from next-generation sequencing (NGS) far exceeds the number needed to correlate with microsatellite parameter estimates. Our study illustrates that diversity, FST and PCA results from microsatellites can mirror those obtained with SNPs. These results may be generally applicable to small populations, a defining feature of endangered and threatened species, because theory predicts that genetic drift will tend to outweigh selection in small populations.

It contains 16 genotypes and 17901 markers.

Title: Population genetic inferences using immune gene SNPs mirror patterns inferred by microsatellites

Scientific name: Gopherus polyphemus

Common name: Gopher tortoise

DOI: https://doi.org/10.5061/dryad.40c7c


