# Genomic relationship - based genetic parameters and prospects of genomic selection for growth and wood quality traits in Eucalyptus benthamii

This publication discusses: The unique adaptation of Eucalyptus benthamii to low temperatures coupled to fast growth and versatile wood quality has made it a valued plantation species in frost-prone areas worldwide, but little is known on its quantitative genetic parameters for key industrial traits. We used GBLUP additive (GA), additive-dominant (GAD), single-step (HBLUP), and pedigree-based predictive models to estimate lignin, extractives, carbohydrates, and wood density at age 4 and tree volume at age 6. By capturing hidden relatedness and correcting pedigree errors, SNP data disentangled non-additive from additive variance providing more realistic estimates of narrow-sense heritability than pedigrees, and more accurate predictions of trait values. Predictive abilities (PAs) ranged from 0.12 for volume (pedigree-based model) to 0.44 for wood density (models H, GA, and GAD). Considerable dominance variance was seen for all traits, growth was the trait most influenced by it, resulting in PAs 48.9% higher when this effect is considered, a result with important consequences both for clonal propagation and overall selection efficiency (Seff). Using a HBLUP model, phenotypes of non-genotyped trees increased PAs by increasing sample size and provided realized relationships with reduced genotyping cost. In a recurrent selection program, the preclusion of progeny testing provides an increase in Seff between 232% and 299%. In a clonal selection program, the elimination of both progeny and initial clonal trial may increase Seff between 134% and 277%. Increasing selection intensity by genomic prediction resulted in an additional impact on Seff. This study provides groundwork to implement genomic selection in E. benthamii breeding.



It contains 672 genotypes and 60728 markers.

Title: Genomic relationship - based genetic parameters and prospects of genomic selection for growth and wood quality traits in Eucalyptus benthamii

Scientific name: Eucalyptus benthamii

Common name: Camden White Gum

DOI: https://doi.org/10.6084/m9.figshare.14806449 - https://doi.org/10.6084/m9.figshare.14807916


