# Genomic data suggest environmental drivers of fish population structure in the deep sea: A case study for the orange roughy (Hoplostethus atlanticus)

This publication discusses: The accurate identification of conservation units is central to effective management strategies. However, marine environment populations often have large census sizes and few obvious boundaries to gene flow. Poorly understood species in the deep sea are especially at risk of being erroneously managed as a single interbreeding stock (panmictic). However, mistaking cryptic structure for panmixia can have important consequences leading to ineffective management and population decline. Furthermore, characteristics of populations essential for their survival may reflect local adaptation, not evident from surveys using neutral genetic markers.

We use genomic methodologies to test hypotheses about potential drivers of cryptic population structure among marine fish populations in the deep sea. In particular, we consider the possibility of isolation by distance along habitat corridors for a species dependent on a specific depth range and test for differentiation at functional loci across potential ecological habitat boundaries.

For a species previously understood to be panmictic in the North Atlantic, we reveal neutral genetic differentiation among regional populations isolated by distance along deep-water channels. We also reveal a distinct pattern of cryptic genetic structure for putative functional loci, despite apparently high levels of gene flow.

Synthesis and applications. This example reflects the life history and ecology of a broad range of deep-sea species currently exploited in intensive fisheries or as bycatch. In many cases where these populations are managed as a single stock, more effective management could be achieved using the methods we describe to identify relevant eco-evolutionary processes, facilitated by genomic methods, permitting the recognition of cryptic stock structure. This approach also allows managers to more directly promote the essential but elusive conservation of adaptive potential.

It contains 1734 genotypes and 7714 markers.

Title: Genomic data suggest environmental drivers of fish population structure in the deep sea: A case study for the orange roughy (Hoplostethus atlanticus)

Scientific name: Hoplostethus atlanticus

Common name: Orange roughy

DOI: https://doi.org/10.26188/5d9bc8afa5b54


