# Springtail phylogeography highlights biosecurity risks of repeated invasions and intraregional transfers among remote islands

This publication discusses: Human-mediated transport of species outside their natural range is a rapidly growing threat to biodiversity, particularly for island ecosystems that have evolved in isolation. The genetic structure underpinning island populations will largely determine their response to increased transport and thus help to inform biosecurity management. However, this information is severely lacking for some groups, such as the soil fauna. We therefore analysed the phylogeographic structure of an indigenous and an invasive springtail species (Collembola: Poduromorpha), each distributed across multiple remote sub-Antarctic islands, where human activity is currently intensifying. For both species, we generated a genome-wide SNP data set and additionally analysed all available COI barcodes. Genetic differentiation in the indigenous springtail Tullbergia bisetosa is substantial among (and, to a lesser degree, within) islands, reflecting low dispersal and historic population fragmentation, while COI patterns reveal ancestral signatures of postglacial recolonization. This pronounced geographic structure demonstrates the key role of allopatric divergence in shaping the region's diversity and highlights the vulnerability of indigenous populations to genetic homogenization via human transport. For the invasive species Hypogastrura viatica, nuclear genetic structure is much less apparent, particularly for islands linked by regular shipping, while diverged COI haplotypes indicate multiple independent introductions to each island. Thus, human transport has likely facilitated this species‚Äô persistence since its initial colonization, through the ongoing introduction and inter-island spread of genetic variation. These findings highlight the different evolutionary consequences of human transport for indigenous and invasive soil species. Crucially, both outcomes demonstrate the need for improved intraregional biosecurity among remote island systems, where the policy focus to date has been on external introductions.

It contains 178 genotypes and 5680 markers.

Title: Springtail phylogeography highlights biosecurity risks of repeated invasions and intraregional transfers among remote islands

Scientific name: Tullbergia bisetosa

Common name: Springtail

DOI: https://doi.org/10.26180/5d6e10736bed4


