# Re-evaluating Coho salmon (Oncorhynchus kisutch) conservation units in Canada using genomic data

This publication discusses: Conservation units (CUs) are important tools for supporting the implementation of standardized management practices for exploited species. Following the adoption of the Wild Salmon Policy in Canada, CUs were defined for Pacific salmon based on characteristics related to ecotype, life history and genetic variation using microsatellite markers as indirect measures of local adaptation. Genomic data sets have the potential to improve the definition of CUs by reducing variance around estimates of population genetic parameters, thereby increasing the power to detect more subtle patterns of population genetic structure and by providing an opportunity to incorporate adaptive information more directly with the identification of variants putatively under selection. We used one of the largest genomic data sets recently published for a nonmodel species, comprising 5662 individual Coho salmon (Oncorhynchus kisutch) from 149 sampling locations and a total of 24,542 high-quality SNPs obtained using genotyping-by-sequencing and mapped to the Coho salmon reference genome to (1) evaluate the current delineation of CUs for Coho in Canada and (2) compare patterns of population structure observed using neutral and outlier loci from genotype‚Äìenvironment association analyses to determine whether separate CUs that capture adaptive diversity are needed. Our results reflected CU boundaries on the whole, with the majority of sampling locations managed in the same CU clustering together within genetic groups. However, additional groups that are not currently represented by CUs were also uncovered. We observed considerable overlap in the genetic clusters identified using neutral or candidate loci, indicating a general congruence in patterns of genetic variation driven by local adaptation and gene flow in this species. Consequently, we suggest that the current CU boundaries for Coho salmon are largely well-suited for meeting the Canadian Wild Salmon Policy's objective of defining biologically distinct groups, but we highlight specific areas where CU boundaries may be refined.

It contains 5581 genotypes and 24542 markers.

Title: Re-evaluating Coho salmon (Oncorhynchus kisutch) conservation units in Canada using genomic data

Scientific name: Oncorhynchus kisutch

Common name: Coho Salmon

DOI: https://doi.org/10.5061/dryad.r4xgxd2gx


