# Enhancing genomic prediction with genome-wide association studies in multiparental maize populations

This publication discusses: Genome-wide association mapping using dense marker sets has identified some nucleotide variants affecting complex traits that have been validated with fine-mapping and functional analysis. However, many sequence variants associated with complex traits in maize have small effects and low repeatability. In contrast to genome-wide association study (GWAS), genomic prediction (GP) is typically based on models incorporating information from all available markers, rather than modeling effects of individual loci. We considered methods to integrate results of GWASs into GP models in the context of multiple interconnected families. We compared association tests based on a biallelic additive model constraining the effect of a single-nucleotide polymorphism (SNP) to be equal across all families in which it segregates to a model in which the effect of a SNP can vary across families. Association SNPs were then included as fixed effects into a GP model that also included the random effects of the whole genome background. Simulation studies revealed that the effectiveness of this joint approach depends on the extent of polygenicity of the traits. Congruent with this finding, cross-validation studies indicated that GP including the fixed effects of the most significantly associated SNPs along with the polygenic background was more accurate than the polygenic background model alone for moderately complex but not highly polygenic traits measured in the maize nested association mapping population. Individual SNPs with strong and robust association signals can effectively improve GP. Our approach provides a new integrative modeling approach for both reliable gene discovery and robust GP.

It contains 5000 genotypes and 1328174 markers.

Title: Enhancing genomic prediction with genome-wide association studies in multiparental maize populations

Scientific name: Zea mays

Common name: Maize

DOI: https://doi.org/10.5061/dryad.cd3hv


