# Accelerating wheat breeding for end-use quality through association mapping and multivariate genomic prediction

This publication discusses: In hard-winter wheat (Triticum aestivum L.) breeding, the evaluation of end-use quality is expensive and time-consuming, being relegated to the final stages of the breeding program after selection for many traits including disease resistance, agronomic performance, and grain yield. In this study, our objectives were to identify genetic variants underlying baking quality traits through genome-wide association study (GWAS) and develop improved genomic selection (GS) models for the quality traits in hard-winter wheat. Advanced breeding lines (n = 462) from 2015‚Äì2017 were genotyped using genotyping-by-sequencing (GBS) and evaluated for baking quality. Significant associations were detected for mixograph mixing time and bake mixing time, most of which were within or in tight linkage to glutenin and gliadin loci and could be suitable for marker-assisted breeding. Candidate genes for newly associated loci are phosphate-dependent decarboxylase and lipid transfer protein genes, which are believed to affect nitrogen metabolism and dough development, respectively. The use of GS can both shorten the breeding cycle time and significantly increase the number of lines that could be selected for quality traits, thus we evaluated various GS models for end-use quality traits. As a baseline, univariate GS models had 0.25‚Äì0.55 prediction accuracy in cross-validation and from 0 to 0.41 in forward prediction. By including secondary traits as additional predictor variables (univariate GS with covariates) or correlated response variables (multivariate GS), the prediction accuracies were increased relative to the univariate model using only genomic information. The improved genomic prediction models have great potential to further accelerate wheat breeding for end-use quality.

It contains 462 genotypes and 41340 markers.

Title: Accelerating wheat breeding for end-use quality through association mapping and multivariate genomic prediction

Scientific name: Triticum aestivum

Common name: Wheat

DOI: https://doi.org/10.5061/dryad.rbnzs7hbx


