# Genomic prediction accuracies in space and time for height and wood density of Douglas-fir using exome capture as the genotyping platform

This publication discusses: Background

Genomic selection (GS) can offer unprecedented gains, in terms of cost efficiency and generation turnover, to forest tree selective breeding; especially for late expressing and low heritability traits. Here, we used: 1) exome capture as a genotyping platform for 1372 Douglas-fir trees representing 37 full-sib families growing on three sites in British Columbia, Canada and 2) height growth and wood density (EBVs), and deregressed estimated breeding values (DEBVs) as phenotypes. Representing models with (EBVs) and without (DEBVs) pedigree structure. Ridge regression best linear unbiased predictor (RR-BLUP) and generalized ridge regression (GRR) were used to assess their predictive accuracies over space (within site, cross-sites, multi-site, and multi-site to single site) and time (age-age/ trait-trait).



Results

The RR-BLUP and GRR models produced similar predictive accuracies across the studied traits. Within-site GS prediction accuracies with models trained on EBVs were high (RR-BLUP: 0.79‚Äì0.91 and GRR: 0.80‚Äì0.91), and were generally similar to the multi-site (RR-BLUP: 0.83‚Äì0.91, GRR: 0.83‚Äì0.91) and multi-site to single-site predictive accuracies (RR-BLUP: 0.79‚Äì0.92, GRR: 0.79‚Äì0.92). Cross-site predictions were surprisingly high, with predictive accuracies within a similar range (RR-BLUP: 0.79‚Äì0.92, GRR: 0.78‚Äì0.91). Height at 12 years was deemed the earliest acceptable age at which accurate predictions can be made concerning future height (age-age) and wood density (trait-trait). Using DEBVs reduced the accuracies of all cross-validation procedures dramatically, indicating that the models were tracking pedigree (family means), rather than marker-QTL LD.



Conclusions

While GS models‚Äô prediction accuracies were high, the main driving force was the pedigree tracking rather than LD. It is likely that many more markers are needed to increase the chance of capturing the LD between causal genes and markers.

It contains 1872 genotypes and 74200 markers.

Title: Genomic prediction accuracies in space and time for height and wood density of Douglas-fir using exome capture as the genotyping platform

Scientific name: Pseudotsuga menziesii

Common name: Douglas fir

DOI: https://doi.org/10.5061/dryad.vk048


