# Optimizing genomic selection for blight resistance in American chestnut backcross populations: A trade-off with American chestnut ancestry implies resistance is polygenic

This publication discusses: American chestnut was once a foundation species of eastern North American forests, but was rendered functionally extinct in the early 20th century by an exotic fungal blight (Cryphonectria parasitica). Over the past 30 years, the American Chestnut Foundation (TACF) has pursued backcross breeding to generate hybrids that combine the timber-type form of American chestnut with the blight resistance of Chinese chestnut based on a hypothesis of major gene resistance. To accelerate selection within two backcross populations that descended from two Chinese chestnuts, we developed genomic prediction models for five presence/absence blight phenotypes of 1,230 BC3F2 selection candidates and average canker severity of their BC3F3 progeny. We also genotyped pure Chinese and American chestnut reference panels to estimate the proportion of BC3F2 genomes inherited from parent species. We found that genomic prediction from a method that assumes an infinitesimal model of inheritance (HBLUP) has similar accuracy to a method that tends to perform well for traits controlled by major genes (Bayes C). Furthermore, the proportion of BC3F2 trees' genomes inherited from American chestnut was negatively correlated with the blight resistance of these trees and their progeny. On average, selected BC3F2 trees inherited 83% of their genome from American chestnut and have blight resistance that is intermediate between F1 hybrids and American chestnut. Results suggest polygenic inheritance of blight resistance. The blight resistance of restoration populations will be enhanced through recurrent selection, by advancing additional sources of resistance through fewer backcross generations, and by potentially by breeding with transgenic blight-tolerant trees.

It contains 642 genotypes and 65227 markers.

Title: Optimizing genomic selection for blight resistance in American chestnut backcross populations: A trade-off with American chestnut ancestry implies resistance is polygenic

Scientific name: Castanea dentata

Common name: American Chestnut

DOI: https://doi.org/10.5061/dryad.8w9ghx3gn


