# Population Genomic Analysis of the Blue Crab Callinectes sapidus Using Genotyping-By-Sequencing

This publication discusses: Previous genetic studies of the blue crab Callinectes sapidus along the U.S. Atlantic and Gulf coasts have reported weak or temporally variable spatial structure, suggesting high gene flow among distant populations possibly facilitated by long-distance larval dispersal or other features of blue crab life history. The use of relatively few genetic markers, however, may have limited power to detect subtle but significant structure that could inform fisheries management. In this study, the potential for genome-scale datasets to uncover subtle patterns of population structure in the blue crab was examined using a high-throughput genotyping approach (genotyping-by-sequencing) that generated data for more than 9,600 single nucleotide polymorphisms (SNPs) in crabs from three populations: Panama City Beach, FL, Agawam River, MA, and Porto Alegre, Brazil. Principle components analyses among the three populations revealed very distinct clustering of the Brazilian samples from U.S. populations, likely reflecting restricted gene flow across the equator. Detailed analysis of population structure between the two U.S. populations revealed low but significant genetic differentiation (FST = 0.0103), with FST values ranging from -0.05 to 0.48. Previous studies have failed to detect significant genetic structure on a similar geographic scale. FST outlier analysis identified 242 loci (2.45% of total) with statistically extreme values at the false discovery rate Œ± = 0.05 level, only 16 of which showed significant sequence homology to annotated proteins via BLASTx alignment. Top BLASTx hits were to crustacean or arthropod sequences and 8 of the 16 had high sequence similarity to transposable elements or related machinery. Finally, results of population assignment tests for the two U.S. populations showed that the full marker dataset provided good power to assign individuals back to their population of origin (‚àº83% and 92% success for Panama City Beach and Agawam River, respectively), which dropped significantly when using only 500 randomly selected SNPs (‚àº61% and 72% success). Overall, this study demonstrates the great utility of high-throughput sequencing technologies for characterizing fine-scale patterns of genetic structure in blue crabs, and this approach should substantially improve the delineation of stock structure and further advance our understanding of blue crab population connectivity and ecology.

It contains 26 genotypes and 5566 markers.

Title: Population Genomic Analysis of the Blue Crab Callinectes sapidus Using Genotyping-By-Sequencing

Scientific name: Callinectes sapidus

Common name: Blue Crab

DOI: https://doi.org/10.5061/dryad.c3318


