<div id="annotation-session-panel">
    <div class="panel panel-default"  :class="classObject">
        <div class="panel-heading">
            Annotation sessions
            <span class="pull-right">
                <loader :active="loading"></loader>
                <a class="btn btn-default btn-xs" href="{{route('manual-tutorials', ['volumes', 'annotation-sessions'])}}" title="Learn more on annotation sessions" target="_blank"><span class="fa fa-info-circle" aria-hidden="true"></span></a>
                <button class="btn btn-default btn-xs" title="Edit annotation sessions" v-on:click="toggleEditing" :class="{active: editing}"><span class="fa fa-pencil-alt" aria-hidden="true"></span></button>
            </span>
        </div>
        <div class="panel-body" v-cloak v-if="editing">
            <form role="form" class="form clearfix" v-on:submit.prevent="submit">
                <div class="row">
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('name')}">
                        <label class="control-label" for="as-name">Name</label>
                        <input type="text" class="form-control" name="name" id="as-name" placeholder="My annotation session" v-model="editedSession.name" title="Annotation session name" required>
                        <p class="help-block" v-text="getError('name')" v-if="hasError('name')"></p>
                    </div>
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('description')}">
                        <label class="control-label" for="as-description">Description</label>
                        <input type="text" class="form-control" name="description" id="as-description" placeholder="This is my new session." v-model="editedSession.description" title="Short annotation session description">
                        <p class="help-block" v-text="getError('description')" v-if="hasError('description')"></p>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('starts_at')}">
                        <label class="control-label" for="as-starts-at">Start date</label>
                        <datepicker-dropdown v-model="editedSession.starts_at" placeholder="{{$today->toDateString()}}"></datepicker-dropdown>
                        <p class="help-block" v-text="getError('starts_at')" v-if="hasError('starts_at')"></p>
                    </div>
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('ends_at')}">
                        <label class="control-label" for="as-ends-at">End date</label>
                        <datepicker-dropdown v-model="editedSession.ends_at" placeholder="{{$today->addDay()->toDateString()}}"></datepicker-dropdown>
                        <p class="help-block" v-text="getError('ends_at')" v-if="hasError('ends_at')"></p>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('users')}">
                        <label class="control-label" for="new-user">New user</label>
                        <typeahead class="typeahead--block" :items="availableUsers" title="Add a new user to the session" placeholder="Joe User" v-on:select="selectUser" :clear-on-select="true" more-info="affiliation"></typeahead>
                    </div>
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('users')}">
                        <label class="control-label" for="users">Users</label>
                        <div class="form-control tag-list" readonly>
                            <user-tag v-for="user in editedSession.users" :key="user.id" :user="user" v-on:remove="removeUser"></user-tag>
                        </div>
                        <p class="help-block" v-text="getError('users')" v-if="hasError('users')"></p>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('hide_other_users_annotations')}">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="as-hide-other-users" v-model="editedSession.hide_other_users_annotations"> Hide annotations of other users while the annotation session is active.
                            </label>
                        </div>
                        <p class="help-block" v-text="getError('hide_other_users_annotations')" v-if="hasError('hide_other_users_annotations')"></p>
                    </div>
                    <div class="form-group col-xs-6" :class="{'has-error':hasError('hide_own_annotations')}">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="as-hide-own-users" v-model="editedSession.hide_own_annotations"> Hide annotations of the own user that were created before the annotation session started.
                            </label>
                        </div>
                        <p class="help-block" v-text="getError('hide_own_annotations')" v-if="hasError('hide_own_annotations')"></p>
                    </div>
                </div>
                <div v-if="hasNewSession">
                    <button type="button" class="btn btn-default pull-right" title="Clear form data" v-on:click="clearEditedSession" :disabled="loading || null">Clear</button>
                    <button type="submit" class="btn btn-success" title="Create new annotation session" :disabled="loading || null">Create</button>
                </div>
                <div v-else>
                    <span class="pull-right">
                        <button type="button" class="btn btn-default" title="Cancel editing" v-on:click="clearEditedSession" :disabled="loading || null">Cancel</button>
                        <button type="button" class="btn btn-danger" title="Delete this annotation session" v-on:click="deleteSession" :disabled="loading || null">Delete</button>
                    </span>
                    <button type="submit" class="btn btn-success" title="Save changes" :disabled="loading || null">Save</button>
                </div>
            </form>
        </div>
        <ul class="list-group images-list" v-cloak>
            <list-item v-for="session in orderedSessions" :key="session.id" :session="session" :editing="editing" :edit-id="editedSession.id" v-on:edit="editSession"></list-item>
            <li class="list-group-item text-muted" v-if="!hasSessions">There are no annotation sessions.</li>
        </ul>
    </div>
</div>
