# BIIGLE Core

[![Test status](https://github.com/biigle/core/workflows/Tests/badge.svg)](https://github.com/biigle/core/actions?query=workflow%3ATests)

This is the main application core of BIIGLE.

## Contributions and bug reports

Contributions to BIIGLE are always welcome. Check out [`CONTRIBUTING.md`](CONTRIBUTING.md) to get started.

## Support

If you have a question or request that is not a [bug report or feature request](CONTRIBUTING.md), please start a new [discussion](https://github.com/orgs/biigle/discussions) about it.

## Installation

BIIGLE requires [Docker](https://docs.docker.com/install/) and [Docker Compose](https://docs.docker.com/compose/install/) to run.

### For Production

Head over to [biigle/biigle](https://github.com/biigle/biigle) to configure and build your production instance.

### For Development

Take a look at [`DEVELOPING.md`](DEVELOPING.md) for a detailed explanation on how to develop BIIGLE.

### Versions

Although BIIGLE versions and BIIGLE module versions look like [semantic versioning](https://semver.org/), they are not. Only the most recent versions are compatible with each other. Patch versions are mostly backwards compatible, though.

## Security Vulnerabilities

If you discover a security vulnerability within BIIGLE, please send an email to the BIIGLE team via <info@biigle.de>. All security vulnerabilities will be promptly addressed.
