# Efficient Solution and Learning of Robust Factored MDPs

## Overview

Welcome! This is the artifact accompanying our AAAI 2026 submission **Efficient Solution and Learning of Robust Factored MDPs**. This guide will walk you through the installation and usage of our algorithms for solving and learning robust factored Markov Decision Processes (rf-MDPs).

Our project builds on the [PRISM model checker](https://github.com/prismmodelchecker/prism). Please ensure the following prerequisites are met before proceeding with installation.

## Prerequisites

To set up the project, you will need:

- **GNU Make**
- **C/C++ Compiler** (e.g., `gcc`, `g++`)
- **Java Development Kit (JDK)**, version 9 or higher

To run experiments involving **McCormick envelopes**, a valid installation of **Gurobi** with a valid license is required. You can obtain a free academic license and follow installation instructions here:

- [Gurobi Installation Guide](https://support.gurobi.com/hc/en-us/articles/4534161999889-How-do-I-install-Gurobi-Optimizer)
- [Gurobi Academic License](https://www.gurobi.com/academia/academic-program-and-licenses/)

## Installation and Usage

### 1. Unpack and Build

To unpack and build the project:

```sh
unzip robust_factored_mdps.zip &&
cd robust_factored_mdps/prism &&
make
```

### 2. Running the Experiments

Navigate to the `prism` directory to execute the experiments.

---

#### **Solving** rf-MDPs (Tables 1 and 2)

```sh
PRISM_JAVAMAXMEM=<maxmem> PRISM_MAINCLASS=imdpcomp.ExperimentRunner bin/prism -c <casestudy> -o <composition_type> -e <epsilon>
```

- `<maxmem>`: Maximum Java heap memory (e.g., `50g` to ensure sufficient memory for all experiments)  
- `<casestudy>`: The case study to run (e.g., `aircraft`, `lake`)  
- `<composition_type>`: The composition method, e.g.:
  - `smart` (McCormick envelopes)
  - `vertex` (exact vertex enumeration)
  - `interval` (interval arithmetic)
  - `all` (run all methods sequentially)  
- `<epsilon>`: Perturbation radius for the nominal transition kernel

For a **detailed explanation** of all available options, the **-h** option is available.

  **Note on Gurobi**: In case you see a Gurobi error, you have to add the corresponding files mentioned in the error to the prism/lib folder (i.e., the .dylib or .so files) from your Gurobi installation. We could not provide these due to the limited file size of OpenReview. 

---

#### **Learning** rf-MDPs (Figures 3 and 4)

```sh
PRISM_JAVAMAXMEM=<maxmem> PRISM_MAINCLASS=learning.CompositionLearner bin/prism -c <casestudy> -o <composition_type>
```

As above, use the `-h` flag for a **full list of parameter options** and further guidance.

