
import argparse, os
import numpy as np
import matplotlib.pyplot as plt

def fake_points(n=60, seed=0):
    rng = np.random.RandomState(seed)
    rl = rng.rand(n, 2) * np.array([0.4, 0.4])
    base = rng.rand(n, 2) * np.array([0.8, 0.8]) + np.array([0.2, 0.2])
    return rl, base

if __name__ == "__main__":
    ap = argparse.ArgumentParser()
    ap.add_argument("--results", required=False)
    args = ap.parse_args()
    rl, base = fake_points()
    plt.figure()
    plt.scatter(base[:,0], base[:,1], label="Baseline", alpha=0.6)
    plt.scatter(rl[:,0], rl[:,1], label="RL-MOTS", marker="^")
    plt.xlabel("Normalized Energy")
    plt.ylabel("Normalized Cost")
    plt.legend()
    os.makedirs("results/figs", exist_ok=True)
    plt.savefig("results/figs/pareto_energy_cost.png", dpi=220, bbox_inches="tight")
    print("Saved results/figs/pareto_energy_cost.png")
