
# RL-MOTS Reference Implementation (DQN for Multi-Objective Task Scheduling)

This repository contains a **reference implementation** of the RL-MOTS framework described in the manuscript
*Dynamic Multi-Objective Task Scheduling in Cloud Computing Using Reinforcement Learning for Energy and Cost Optimization*.

> **Note**: This codebase is a clean-room implementation produced for reproducibility of the paper's concepts.
It includes the DQN agent, a cloud-edge scheduling environment, classical baselines, configuration files, and
scripts to run experiments and export results/plots (including Pareto fronts).

## Features
- DQN agent (Double-DQN + Prioritized Replay)
- Multi-objective reward: energy, cost, QoS (deadline satisfaction)
- Cloud–edge environment with VMs/edge nodes, tasks, and migration penalty
- Baselines: FCFS, Max-Min, Tabular Q-Learning (toy), and plug-in hooks for SR-PSO / VMS-MCSA (placeholders)
- Configurable experiment runner with seeds and task loads
- Plot utilities for makespan, throughput, ARUR, DI, and Pareto fronts

## Quick Start
```bash
python -m venv venv
source venv/bin/activate  # (Windows: venv\Scripts\activate)
pip install -r requirements.txt
python scripts/run_experiments.py --config configs/google2019_small.yaml
python scripts/plot_pareto.py --results results/google2019_small
```

## Data
The repo comes with **synthetic generators** aligned with the statistics of Google-2019 / Alibaba-2018 / Azure-2019.
You can replace them with the original traces (subject to their licenses) by dropping processed CSVs into `data/`
and setting the corresponding paths in `configs/*.yaml`.

## Reproducibility
All configs are pinned. The default DQN hyperparameters follow Section 5.3 of the manuscript.

## Citation
See `CITATION.cff`.

## License
MIT
