# MATLAB GUI for Mayotte Landslide-Tsurrogate

**Contact**: Clea Denamiel <br>
**email (institutional)**: cdenami@irb.hr <br>
**email (permanent)**: clea.denamiel@live.fr <br>

## results

Folder where the results of the Landslide Probabilistic Tsunami Hazard Assessment (L-PTHA) are saved in the file PTHA_results.mat as a Matlab structure:
<pre>
% PTHA:
%    struct array with fields:
% 
%    PTHA.input_parameters
%         zone:       string (Piton, Piton Offshore, Piton South, Mayotte South or Mayotte Offshore)
%         area:       string (Petite Terre or Grande Terre)
%         distance:   [1x1 struct] 
%         volume:     [1x1 struct] 
%         friction:   [1x1 struct] 
% 
%    PTHA.max_ele 
%         value: Petite Terre [211x1000 double] => 211 coastal locations and 1000 samples generated by surrogate model 
%             or Grande Terre [287x1000 double] => 287 coastal locations and 1000 samples generated by the surrogate model 
%         units: 'm' 
%         long_name: 'Maximum Tsunami Elevation including tide' 
%
%    PTHA.max_vel 
%         value: Petite Terre [211x1000 double] => 211 coastal locations and 1000 samples generated by surrogate model 
%             or Grande Terre [287x1000 double] => 287 coastal locations and 1000 samples generated by the surrogate model 
%         units: 'm/s'
%         long_name: 'Maximum Tsunami Current including tide'
</pre>
