# MATLAB GUI for Mayotte Landslide-Tsurrogate

**Contact**: Clea Denamiel <br>
**email (institutional)**: cdenami@irb.hr <br>
**email (permanent)**: clea.denamiel@live.fr <br>

## Windows OS Installers

Users with Windows OS that do not want to install or use Matlab, can install the interface by downloading the installer:

https://drive.google.com/file/d/1Yd2zwGBLTqKMUZzFkXwcDPgN6z7c2GXu/view?usp=sharing

## Program

For users familiar with Matlab, the Interface can be added as a Matlab App installer: https://drive.google.com/file/d/11Fsi_AmAUAaIh1aCsyXbxi-PtjqNSIAf/view?usp=sharing

The interface code is also available using the three subfolders: **code**, **data** and **results**.

Once the subfolders downloaded, dowload tidal constituants under data/TMD from the zip file tidal_data.zip provided at this link: https://drive.google.com/file/d/1MhdVq0EFoGYZ_59Lw1Zrow_NGR2hnGxM/view?usp=sharing

### code

To start the Matlab interface, run the program: mayotte_landslide_tsunami_surrogate_model.m 

### data

All the data is provided in the data subfolder. Except the todal constituants under the subfolder TMD that must be download here: https://drive.google.com/file/d/1MhdVq0EFoGYZ_59Lw1Zrow_NGR2hnGxM/view?usp=drive_link


### results

The output of the interface is saved in this subfolder. 

### Tidal Constituants (TPXO 7.2) & Tidal Model Driver (TMD)

The interface uses some of the routines of the TMD Matlab program that can be found under the folder code/TMD_functions: https://www.esr.org/research/polar-tide-models/tmd-software/

The TPXO 7.2 atlas tidal model used in the interface (data/TMD) is an outdated version of the OSU TPXO Tide Models that can be updated at: https://www.tpxo.net/



