# -*- coding: utf-8 -*-
"""Confusion Matrix

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1LcesL3gOcDnDjuqAcI_P5TuxDx63zMsX
"""

import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns

# Define confusion matrices as numpy arrays
confusion_matrices = {
    "Random_Forest": np.array([[411, 432], [106, 1759]]),
    "AdaBoost": np.array([[428, 415], [121, 1744]]),
    "HistGradientBoost": np.array([[460, 383], [90, 1775]])
}

# Determine the maximum value for consistent color scaling across these models
all_values = np.concatenate([cm.flatten() for cm in confusion_matrices.values()])
vmin, vmax = all_values.min(), all_values.max()

# Choose the blue color palette
cmap = "PuBu"

# Iterate over each confusion matrix and plot individually
for model_name, cm in confusion_matrices.items():
    plt.figure(figsize=(6, 5))
    sns.heatmap(cm, annot=True, fmt="d", cmap=cmap, cbar=True,
                vmin=vmin, vmax=vmax, annot_kws={"size": 14}, square=True)

    # Set axis labels
    plt.xlabel("Predicted Label", fontsize=14)
    plt.ylabel("True Label", fontsize=14)

    # Adjust tick parameters
    plt.tick_params(axis='both', which='major', labelsize=12)

    # Optimize layout
    plt.tight_layout()

    # Define filenames
    filename_base = f"confusion_matrix_{model_name}"

    # Save the figure in multiple formats with 300 DPI
    plt.savefig(f"{filename_base}.eps", format="eps", dpi=300)
    plt.savefig(f"{filename_base}.pdf", format="pdf", dpi=300)
    plt.savefig(f"{filename_base}.jpeg", format="jpeg", dpi=300)

    # Close the figure to free memory
    plt.close()

import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns

# Define all confusion matrices as numpy arrays
confusion_matrices = {
    "Random_Forest": np.array([[411, 432], [106, 1759]]),
    "AdaBoost": np.array([[428, 415], [121, 1744]]),
    "HistGradientBoost": np.array([[460, 383], [90, 1775]]),
    "XGBoost": np.array([[432, 411], [75, 1790]]),
    "XGBoost_Calibrated": np.array([[530, 313], [124, 1741]])
}

# Determine the global minimum and maximum values for consistent color scaling
all_values = np.concatenate([cm.flatten() for cm in confusion_matrices.values()])
vmin, vmax = all_values.min(), all_values.max()

# Choose the "PuBu" color palette for all heatmaps
cmap = "PuBu"

# Iterate over each confusion matrix and plot individually
for model_name, cm in confusion_matrices.items():
    plt.figure(figsize=(6, 5))
    sns.heatmap(
        cm,
        annot=True,
        fmt="d",
        cmap=cmap,
        cbar=True,  # Include a colorbar for each individual plot
        vmin=vmin,
        vmax=vmax,
        annot_kws={"size": 14},
        square=True
    )

    # Set axis labels
    plt.xlabel("Predicted Label", fontsize=14)
    plt.ylabel("True Label", fontsize=14)

    # Adjust tick parameters
    plt.tick_params(axis='both', which='major', labelsize=12)

    # Optimize layout
    plt.tight_layout()

    # Define filenames (replace spaces with underscores for file naming)
    filename_base = f"confusion_matrix_{model_name.replace(' ', '_')}"

    # Save the figure in multiple formats with 300 DPI
    plt.savefig(f"{filename_base}.eps", format="eps", dpi=300)
    plt.savefig(f"{filename_base}.pdf", format="pdf", dpi=300)
    plt.savefig(f"{filename_base}.jpeg", format="jpeg", dpi=300)

    # Close the figure to free memory
    plt.close()